/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.xml.Constants;
import org.apache.tuscany.sca.implementation.spring.xml.SpringBeanElement;
import org.apache.tuscany.sca.implementation.spring.xml.SpringBeanIntrospector;
import org.apache.tuscany.sca.implementation.spring.xml.SpringConstructorArgElement;
import org.apache.tuscany.sca.implementation.spring.xml.SpringPropertyElement;
import org.apache.tuscany.sca.implementation.spring.xml.SpringSCAPropertyElement;
import org.apache.tuscany.sca.implementation.spring.xml.SpringSCAReferenceElement;
import org.apache.tuscany.sca.implementation.spring.xml.SpringSCAServiceElement;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringXMLComponentTypeLoader {
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaFactory;
    private ClassLoader cl;
    private SpringBeanIntrospector beanIntrospector;

    public SpringXMLComponentTypeLoader(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory, PolicyFactory policyFactory) {
        this.assemblyFactory = assemblyFactory;
        this.javaFactory = javaFactory;
        this.beanIntrospector = new SpringBeanIntrospector(assemblyFactory, javaFactory, policyFactory);
    }

    protected Class<SpringImplementation> getImplementationClass() {
        return SpringImplementation.class;
    }

    public void load(SpringImplementation implementation) throws ContributionReadException {
        ComponentType componentType = implementation.getComponentType();
        if (componentType == null) {
            throw new ContributionReadException("SpringXMLLoader load: implementation has no ComponentType object");
        }
        if (componentType.isUnresolved()) {
            this.loadFromXML(implementation);
            if (!componentType.isUnresolved()) {
                implementation.setUnresolved(false);
            }
        }
    }

    private void loadFromXML(SpringImplementation implementation) throws ContributionReadException {
        ArrayList<SpringBeanElement> beans = new ArrayList<SpringBeanElement>();
        ArrayList<SpringSCAServiceElement> services = new ArrayList<SpringSCAServiceElement>();
        ArrayList<SpringSCAReferenceElement> references = new ArrayList<SpringSCAReferenceElement>();
        ArrayList<SpringSCAPropertyElement> scaproperties = new ArrayList<SpringSCAPropertyElement>();
        String location = implementation.getLocation();
        try {
            this.cl = Thread.currentThread().getContextClassLoader();
            Resource resource = this.getApplicationContextResource(location, this.cl);
            implementation.setResource(resource);
            implementation.setURI(resource.getURL().toString());
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            XMLStreamReader reader = xmlFactory.createXMLStreamReader(resource.getInputStream());
            this.readBeanDefinition(reader, beans, services, references, scaproperties);
        }
        catch (IOException e) {
            throw new ContributionReadException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException((Throwable)e);
        }
        this.generateComponentType(implementation, beans, services, references, scaproperties);
    }

    private XMLStreamReader getApplicationContextReader(String location) throws ContributionReadException {
        try {
            this.cl = Thread.currentThread().getContextClassLoader();
            Resource resource = this.getApplicationContextResource(location, this.cl);
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            XMLStreamReader reader = xmlFactory.createXMLStreamReader(resource.getInputStream());
            return reader;
        }
        catch (IOException e) {
            throw new ContributionReadException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException((Throwable)e);
        }
    }

    private void readBeanDefinition(XMLStreamReader reader, List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) throws ContributionReadException {
        SpringBeanElement bean = null;
        SpringPropertyElement property = null;
        SpringConstructorArgElement constructorArg = null;
        try {
            boolean completed = false;
            block6: while (!completed) {
                switch (reader.next()) {
                    case 1: {
                        QName qname = reader.getName();
                        if (Constants.IMPORT_ELEMENT.equals(qname)) {
                            String location = reader.getAttributeValue(null, "resource");
                            if (location == null) continue block6;
                            XMLStreamReader ireader = this.getApplicationContextReader(location);
                            this.readBeanDefinition(ireader, beans, services, references, scaproperties);
                            break;
                        }
                        if (Constants.SERVICE_ELEMENT.equals(qname)) {
                            SpringSCAServiceElement service = new SpringSCAServiceElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "type"), reader.getAttributeValue(null, "target"));
                            services.add(service);
                            break;
                        }
                        if (Constants.REFERENCE_ELEMENT.equals(qname)) {
                            SpringSCAReferenceElement reference = new SpringSCAReferenceElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "type"));
                            references.add(reference);
                            break;
                        }
                        if (Constants.SCAPROPERTY_ELEMENT.equals(qname)) {
                            SpringSCAPropertyElement scaproperty = new SpringSCAPropertyElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "type"));
                            scaproperties.add(scaproperty);
                            break;
                        }
                        if (Constants.BEAN_ELEMENT.equals(qname)) {
                            bean = new SpringBeanElement(reader.getAttributeValue(null, "id"), reader.getAttributeValue(null, "class"));
                            break;
                        }
                        if (Constants.PROPERTY_ELEMENT.equals(qname)) {
                            property = new SpringPropertyElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "ref"));
                            break;
                        }
                        if (Constants.CONSTRUCTORARG_ELEMENT.equals(qname)) {
                            constructorArg = new SpringConstructorArgElement(reader.getAttributeValue(null, "ref"), reader.getAttributeValue(null, "type"));
                            break;
                        }
                        if (Constants.REF_ELEMENT.equals(qname)) {
                            String ref = reader.getAttributeValue(null, "bean");
                            if (property != null) {
                                property.setRef(ref);
                            }
                            if (constructorArg == null) continue block6;
                            constructorArg.setRef(ref);
                            break;
                        }
                        if (!Constants.VALUE_ELEMENT.equals(qname)) break;
                        String value = reader.getElementText();
                        if (constructorArg == null) continue block6;
                        constructorArg.addValue(value);
                        if (value.indexOf(".xml") == -1 || bean.getClassName().indexOf(".ClassPathXmlApplicationContext") == -1 && bean.getClassName().indexOf(".FileSystemXmlApplicationContext") == -1) continue block6;
                        XMLStreamReader creader = this.getApplicationContextReader(value);
                        this.readBeanDefinition(creader, beans, services, references, scaproperties);
                        break;
                    }
                    case 2: {
                        if (Constants.BEANS_ELEMENT.equals(reader.getName())) {
                            completed = true;
                            break;
                        }
                        if (Constants.BEAN_ELEMENT.equals(reader.getName())) {
                            beans.add(bean);
                            bean = null;
                            break;
                        }
                        if (Constants.PROPERTY_ELEMENT.equals(reader.getName())) {
                            bean.addProperty(property);
                            property = null;
                            break;
                        }
                        if (!Constants.CONSTRUCTORARG_ELEMENT.equals(reader.getName())) break;
                        bean.addCustructorArgs(constructorArg);
                        constructorArg = null;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException((Throwable)e);
        }
    }

    private void generateComponentType(SpringImplementation implementation, List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) throws ContributionReadException {
        ComponentType componentType = implementation.getComponentType();
        try {
            for (SpringSCAServiceElement serviceElement : services) {
                Class<?> interfaze = this.cl.loadClass(serviceElement.getType());
                Service theService = this.createService(interfaze, serviceElement.getName());
                componentType.getServices().add(theService);
                String beanName = serviceElement.getTarget();
                for (SpringBeanElement beanElement : beans) {
                    if (!beanName.equals(beanElement.getId())) continue;
                    implementation.setBeanForService(theService, beanElement);
                }
            }
            for (SpringSCAReferenceElement referenceElement : references) {
                Class<?> interfaze = this.cl.loadClass(referenceElement.getType());
                Reference theReference = this.createReference(interfaze, referenceElement.getName());
                componentType.getReferences().add(theReference);
            }
            if (services.isEmpty()) {
                for (SpringBeanElement beanElement : beans) {
                    Class<?> beanClass = this.cl.loadClass(beanElement.getClassName());
                    ComponentType beanComponentType = this.assemblyFactory.createComponentType();
                    this.beanIntrospector.introspectBean(beanClass, beanComponentType, implementation);
                    List beanServices = beanComponentType.getServices();
                    componentType.getServices().addAll(beanServices);
                    for (Service beanService : beanServices) {
                        implementation.setBeanForService(beanService, beanElement);
                    }
                }
            }
            for (SpringBeanElement beanElement : beans) {
                boolean unresolvedProperties = false;
                if (beanElement.getProperties().isEmpty()) continue;
                for (SpringPropertyElement propertyElement : beanElement.getProperties()) {
                    if (!this.propertyRefUnresolved(propertyElement.getRef(), beans, references, scaproperties)) continue;
                    unresolvedProperties = true;
                }
                if (!unresolvedProperties) continue;
                Class<?> beanClass = this.cl.loadClass(beanElement.getClassName());
                ComponentType beanComponentType = this.assemblyFactory.createComponentType();
                Map<String, JavaElementImpl> propertyMap = this.beanIntrospector.introspectBean(beanClass, beanComponentType, implementation);
                List beanReferences = beanComponentType.getReferences();
                List beanProperties = beanComponentType.getProperties();
                for (SpringPropertyElement propertyElement : beanElement.getProperties()) {
                    if (!this.propertyRefUnresolved(propertyElement.getRef(), beans, references, scaproperties)) continue;
                    boolean resolved = false;
                    for (Reference reference : beanReferences) {
                        if (!propertyElement.getName().equals(reference.getName())) continue;
                        reference.setName(propertyElement.getRef());
                        componentType.getReferences().add(reference);
                        resolved = true;
                    }
                    if (resolved) continue;
                    for (Property scaproperty : beanProperties) {
                        if (!propertyElement.getName().equals(scaproperty.getName())) continue;
                        scaproperty.setName(propertyElement.getRef());
                        componentType.getProperties().add(scaproperty);
                        implementation.setPropertyClass(scaproperty.getName(), propertyMap.get(scaproperty.getName()).getType());
                        resolved = true;
                    }
                }
            }
            for (SpringSCAPropertyElement scaproperty : scaproperties) {
                if (scaproperty.getType() == null || scaproperty.getName() == null) continue;
                Property theProperty = this.assemblyFactory.createProperty();
                theProperty.setName(scaproperty.getName());
                Class<?> propType = Class.forName(scaproperty.getType());
                theProperty.setXSDType(JavaXMLMapper.getXMLType(propType));
                componentType.getProperties().add(theProperty);
                implementation.setPropertyClass(theProperty.getName(), propType);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ContributionReadException((Throwable)e);
        }
        catch (InvalidInterfaceException e) {
            throw new ContributionReadException((Throwable)e);
        }
        catch (ContributionResolveException e) {
            // empty catch block
        }
        componentType.setUnresolved(false);
        implementation.setComponentType(componentType);
    }

    private boolean propertyRefUnresolved(String ref, List<SpringBeanElement> beans, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) {
        boolean unresolved = true;
        if (ref != null) {
            for (SpringBeanElement beanElement : beans) {
                if (!ref.equals(beanElement.getId())) continue;
                unresolved = false;
                break;
            }
            if (unresolved) {
                for (SpringSCAReferenceElement referenceElement : references) {
                    if (!ref.equals(referenceElement.getName())) continue;
                    unresolved = false;
                    break;
                }
            }
            if (unresolved) {
                for (SpringSCAPropertyElement propertyElement : scaproperties) {
                    if (!ref.equals(propertyElement.getName())) continue;
                    unresolved = false;
                    break;
                }
            }
        } else {
            unresolved = false;
        }
        return unresolved;
    }

    protected Resource getApplicationContextResource(String locationAttr, ClassLoader cl) throws ContributionReadException {
        block15: {
            File manifestFile = null;
            File locationFile = null;
            URL url = cl.getResource(locationAttr);
            if (url == null) {
                throw new ContributionReadException("SpringXMLLoader getApplicationContextResource: unable to find resource file " + locationAttr);
            }
            String path = url.getPath();
            locationFile = new File(path);
            if (locationFile.isDirectory()) {
                try {
                    File appXmlFile;
                    Manifest mf;
                    Attributes mainAttrs;
                    String appCtxPath;
                    manifestFile = new File(locationFile, "META-INF" + File.separator + "MANIFEST.MF");
                    if (manifestFile.exists() && (appCtxPath = (mainAttrs = (mf = new Manifest(new FileInputStream(manifestFile))).getMainAttributes()).getValue("Spring-Context")) != null && (appXmlFile = new File(locationFile, appCtxPath)).exists()) {
                        return new UrlResource(appXmlFile.toURL());
                    }
                    appXmlFile = new File(locationFile, "META-INF" + File.separator + "spring" + File.separator + "application-context.xml");
                    if (appXmlFile.exists()) {
                        return new UrlResource(appXmlFile.toURL());
                    }
                    break block15;
                }
                catch (IOException e) {
                    throw new ContributionReadException("Error reading manifest " + manifestFile);
                }
            }
            if (locationFile.isFile() && locationFile.getName().endsWith(".jar")) {
                try {
                    JarEntry je;
                    Attributes mainAttrs;
                    String appCtxPath;
                    JarFile jf = new JarFile(locationFile);
                    Manifest mf = jf.getManifest();
                    if (mf != null && (appCtxPath = (mainAttrs = mf.getMainAttributes()).getValue("Spring-Context")) != null && (je = jf.getJarEntry(appCtxPath)) != null) {
                        return new UrlResource(new URL("jar:" + locationFile.toURI().toURL() + "!/" + appCtxPath));
                    }
                    je = jf.getJarEntry("META-INF/spring/application-context.xml");
                    if (je != null) {
                        return new UrlResource(new URL("jar:" + locationFile.toURI().toURL() + "!/" + "application-context.xml"));
                    }
                    break block15;
                }
                catch (IOException e) {
                    throw new ContributionReadException("SpringXMLLoader getApplicationContextResource:  IO exception reading context file.", (Throwable)e);
                }
            }
            if (locationFile.getName().endsWith(".xml")) {
                return new UrlResource(url);
            }
            try {
                Manifest mf;
                Attributes mainAttrs;
                String appCtxPath;
                String jarEntry;
                JarFile jf;
                JarEntry je;
                if (locationFile.getPath().indexOf(".jar") > 0 && (je = (jf = new JarFile(jarEntry = url.getPath().substring(6, url.getPath().indexOf("!")))).getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + "META-INF" + "/" + "MANIFEST.MF")) != null && (appCtxPath = (mainAttrs = (mf = new Manifest(jf.getInputStream(je))).getMainAttributes()).getValue("Spring-Context")) != null && (je = jf.getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + appCtxPath)) != null) {
                    return new UrlResource(new URL("jar:" + url.getPath() + "/" + appCtxPath));
                }
            }
            catch (IOException e) {
                throw new ContributionReadException("Error reading manifest " + manifestFile);
            }
        }
        throw new ContributionReadException("SpringXMLLoader getApplicationContextResource: META-INF/spring/application-context.xmlnot found");
    }

    public Service createService(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        service.setInterfaceContract((InterfaceContract)interfaceContract);
        service.setName(name);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface((Interface)callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface((Interface)callbackInterface);
        }
        return service;
    }

    private Reference createReference(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        reference.setInterfaceContract((InterfaceContract)interfaceContract);
        reference.setName(name);
        reference.setMultiplicity(Multiplicity.ONE_ONE);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        reference.getInterfaceContract().setInterface((Interface)callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            reference.getInterfaceContract().setCallbackInterface((Interface)callbackInterface);
        }
        return reference;
    }
}

