/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.script.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.script.ScriptImplementation;
import org.apache.tuscany.sca.implementation.script.ScriptImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ScriptImplementationProcessor
implements StAXArtifactProcessor<ScriptImplementation> {
    private static final QName IMPLEMENTATION_SCRIPT = ScriptImplementation.TYPE;
    private AssemblyFactory assemblyFactory;
    private ContributionFactory contributionFactory;
    private ScriptImplementationFactory scriptImplementationFactory;

    public ScriptImplementationProcessor(ExtensionPointRegistry registry) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
        this.scriptImplementationFactory = (ScriptImplementationFactory)modelFactories.getFactory(ScriptImplementationFactory.class);
    }

    public QName getArtifactType() {
        return IMPLEMENTATION_SCRIPT;
    }

    public Class<ScriptImplementation> getModelType() {
        return ScriptImplementation.class;
    }

    public ScriptImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String language;
        ScriptImplementation implementation = this.scriptImplementationFactory.createScriptImplementation();
        implementation.setUnresolved(true);
        String script = reader.getAttributeValue(null, "script");
        if (script != null) {
            implementation.setScript(script);
        }
        if ((language = reader.getAttributeValue(null, "language")) != null) {
            implementation.setLanguage(language);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_SCRIPT.equals(reader.getName()))) {
        }
        return implementation;
    }

    public void resolve(ScriptImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (implementation.getScript() != null) {
            Artifact artifact = this.contributionFactory.createArtifact();
            artifact.setURI(implementation.getScript());
            Artifact resolved = (Artifact)resolver.resolveModel(Artifact.class, (Object)artifact, context);
            if (resolved.getLocation() != null) {
                implementation.setLocation(resolved.getLocation());
            } else {
                this.error(context.getMonitor(), "CouldNotResolveScript", resolver, implementation.getScript());
            }
            String componentTypeURI = implementation.getScript();
            componentTypeURI = componentTypeURI.substring(0, componentTypeURI.lastIndexOf(46));
            componentTypeURI = componentTypeURI + ".componentType";
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setUnresolved(true);
            componentType.setURI(componentTypeURI);
            componentType = (ComponentType)resolver.resolveModel(ComponentType.class, (Object)componentType, context);
            if (!componentType.isUnresolved()) {
                implementation.getProperties().addAll(componentType.getProperties());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getServices().addAll(componentType.getServices());
            }
        }
        implementation.setUnresolved(false);
    }

    public void write(ScriptImplementation implementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.setPrefix("script", IMPLEMENTATION_SCRIPT.getNamespaceURI());
        writer.writeStartElement(IMPLEMENTATION_SCRIPT.getNamespaceURI(), IMPLEMENTATION_SCRIPT.getLocalPart());
        writer.writeNamespace("script", IMPLEMENTATION_SCRIPT.getNamespaceURI());
        if (implementation.getScript() != null) {
            writer.writeAttribute("script", implementation.getScript());
        }
        if (implementation.getLanguage() != null) {
            writer.writeAttribute("language", implementation.getLanguage());
        }
        writer.writeEndElement();
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-script-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }
}

