/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.module;

import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.CglibProxyFactory;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.java.invocation.JavaCallbackRuntimeWireProcessor;
import org.apache.tuscany.sca.implementation.java.invocation.JavaImplementationProviderFactory;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.util.PolicyHandlerDefinitionsLoader;
import org.apache.tuscany.sca.provider.ProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessorExtensionPoint;

public class JavaRuntimeModuleActivator
implements ModuleActivator {
    private static final Logger logger = Logger.getLogger(JavaRuntimeModuleActivator.class.getName());

    public void start(ExtensionPointRegistry registry) {
        ModelFactoryExtensionPoint factories = (ModelFactoryExtensionPoint)registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        MessageFactory messageFactory = (MessageFactory)factories.getFactory(MessageFactory.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        InterfaceContractMapper interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        ProxyFactoryExtensionPoint proxyFactories = (ProxyFactoryExtensionPoint)registry.getExtensionPoint(ProxyFactoryExtensionPoint.class);
        try {
            proxyFactories.setClassProxyFactory((ProxyFactory)new CglibProxyFactory(messageFactory, interfaceContractMapper));
        }
        catch (NoClassDefFoundError e) {
            logger.warning("Class proxys not supported due to NoClassDefFoundError:" + e.getMessage());
        }
        JavaInterfaceFactory javaFactory = (JavaInterfaceFactory)factories.getFactory(JavaInterfaceFactory.class);
        DataBindingExtensionPoint dataBindings = (DataBindingExtensionPoint)registry.getExtensionPoint(DataBindingExtensionPoint.class);
        PropertyValueFactory factory = (PropertyValueFactory)utilities.getUtility(PropertyValueFactory.class);
        ContextFactoryExtensionPoint contextFactories = (ContextFactoryExtensionPoint)registry.getExtensionPoint(ContextFactoryExtensionPoint.class);
        ComponentContextFactory componentContextFactory = (ComponentContextFactory)contextFactories.getFactory(ComponentContextFactory.class);
        RequestContextFactory requestContextFactory = (RequestContextFactory)contextFactories.getFactory(RequestContextFactory.class);
        List policyHandlerClassNames = null;
        policyHandlerClassNames = PolicyHandlerDefinitionsLoader.loadPolicyHandlerClassnames();
        ExtensibleProxyFactory proxyFactory = new ExtensibleProxyFactory(proxyFactories);
        JavaImplementationProviderFactory javaImplementationProviderFactory = new JavaImplementationProviderFactory((ProxyFactory)proxyFactory, dataBindings, factory, componentContextFactory, requestContextFactory, policyHandlerClassNames);
        ProviderFactoryExtensionPoint providerFactories = (ProviderFactoryExtensionPoint)registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        providerFactories.addProviderFactory((ProviderFactory)javaImplementationProviderFactory);
        RuntimeWireProcessorExtensionPoint wireProcessorExtensionPoint = (RuntimeWireProcessorExtensionPoint)registry.getExtensionPoint(RuntimeWireProcessorExtensionPoint.class);
        if (wireProcessorExtensionPoint != null) {
            wireProcessorExtensionPoint.addWireProcessor((RuntimeWireProcessor)new JavaCallbackRuntimeWireProcessor(interfaceContractMapper, javaFactory));
        }
    }

    public void stop(ExtensionPointRegistry registry) {
    }
}

