/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.util.List;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.util.PolicyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyHandlingInterceptor
implements Interceptor {
    private Invoker next;
    private List<PolicyHandler> policyHandlers = null;
    private Operation targetOperation = null;

    public PolicyHandlingInterceptor(Operation targetOperation, List<PolicyHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
        this.targetOperation = targetOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        try {
            this.applyPreInvocationPolicies(this.targetOperation, msg);
            msg = this.next.invoke(msg);
        }
        catch (Throwable throwable) {
            this.applyPostInvocationPolices(this.targetOperation, msg);
            throw throwable;
        }
        this.applyPostInvocationPolices(this.targetOperation, msg);
        return msg;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Invoker getNext() {
        return this.next;
    }

    private void applyPreInvocationPolicies(Object ... context) {
        for (PolicyHandler policyHandler : this.policyHandlers) {
            policyHandler.beforeInvoke(context);
        }
    }

    private void applyPostInvocationPolices(Object ... context) {
        for (int count = this.policyHandlers.size() - 1; count >= 0; --count) {
            this.policyHandlers.get(count).afterInvoke(context);
        }
    }
}

