/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopedImplementationProvider;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.RequestContextObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.ResourceHost;
import org.apache.tuscany.sca.implementation.java.injection.ResourceObjectFactory;
import org.apache.tuscany.sca.implementation.java.invocation.JavaComponentContextFactory;
import org.apache.tuscany.sca.implementation.java.invocation.JavaComponentContextProvider;
import org.apache.tuscany.sca.implementation.java.invocation.JavaComponentNameFactory;
import org.apache.tuscany.sca.implementation.java.invocation.JavaImplementationInvoker;
import org.apache.tuscany.sca.implementation.java.invocation.JavaInstanceFactoryProvider;
import org.apache.tuscany.sca.implementation.java.invocation.NoConversationalContractException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.osoa.sca.ComponentContext;
import org.osoa.sca.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImplementationProvider
implements ScopedImplementationProvider {
    private JavaImplementation implementation;
    private JavaComponentContextProvider componentContextProvider;
    private RequestContextFactory requestContextFactory;

    public JavaImplementationProvider(RuntimeComponent component, JavaImplementation implementation, ProxyFactory proxyService, DataBindingExtensionPoint dataBindingRegistry, JavaPropertyValueObjectFactory propertyValueObjectFactory, ComponentContextFactory componentContextFactory, RequestContextFactory requestContextFactory, List<PolicyHandlerTuple> policyHandlerClassNames) {
        this.implementation = implementation;
        this.requestContextFactory = requestContextFactory;
        this.implementation.setPolicyHandlerClassNames(policyHandlerClassNames);
        try {
            JavaInstanceFactoryProvider configuration = new JavaInstanceFactoryProvider(implementation);
            configuration.setProxyFactory(proxyService);
            this.componentContextProvider = new JavaComponentContextProvider(component, configuration, dataBindingRegistry, propertyValueObjectFactory, componentContextFactory, requestContextFactory);
            Scope scope = this.getScope();
            if (scope != Scope.SYSTEM && scope != Scope.COMPOSITE && scope == Scope.CONVERSATION) {
                boolean hasConversationalContract = false;
                for (Service serviceDef : implementation.getServices()) {
                    if (!serviceDef.getInterfaceContract().getInterface().isConversational()) continue;
                    hasConversationalContract = true;
                    break;
                }
                if (!hasConversationalContract) {
                    String name = implementation.getJavaClass().getName();
                    throw new NoConversationalContractException(name);
                }
            }
            if (implementation.getConversationIDMembers().size() > 0) {
                this.componentContextProvider.addConversationIDFactories(implementation.getConversationIDMembers());
            }
            this.componentContextProvider.configureProperties(component.getProperties());
            this.handleResources(implementation, proxyService);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void handleResources(JavaImplementation componentType, ProxyFactory proxyService) {
        for (JavaResourceImpl resource : componentType.getResources().values()) {
            String name = resource.getName();
            ResourceObjectFactory objectFactory = (ResourceObjectFactory)this.componentContextProvider.getInstanceFactoryProvider().getFactories().get(resource.getElement());
            if (objectFactory == null) {
                Class type = resource.getElement().getType();
                if (ComponentContext.class.equals((Object)type)) {
                    objectFactory = new JavaComponentContextFactory(this.componentContextProvider);
                } else if (RequestContext.class.equals((Object)type)) {
                    objectFactory = new RequestContextObjectFactory(this.requestContextFactory, proxyService);
                } else if (String.class.equals((Object)type)) {
                    objectFactory = new JavaComponentNameFactory(this.componentContextProvider);
                } else {
                    boolean optional = resource.isOptional();
                    String mappedName = resource.getMappedName();
                    objectFactory = this.createResourceObjectFactory(type, mappedName, optional, null);
                }
            }
            this.componentContextProvider.addResourceFactory(name, objectFactory);
        }
    }

    private <T> ResourceObjectFactory<T> createResourceObjectFactory(Class<T> type, String mappedName, boolean optional, ResourceHost host) {
        return new ResourceObjectFactory<T>(type, mappedName, optional, host);
    }

    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        try {
            return this.componentContextProvider.createInvoker(operation);
        }
        catch (NoSuchMethodException e) {
            Interface iface = service.getInterfaceContract().getInterface();
            if (iface instanceof JavaInterface) {
                try {
                    Method method = JavaInterfaceUtil.findMethod((Class)((JavaInterface)iface).getJavaClass(), (Operation)operation);
                    return new JavaImplementationInvoker(operation, method, this.componentContextProvider.getComponent());
                }
                catch (NoSuchMethodException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }
            return new JavaImplementationInvoker(operation, this.componentContextProvider.getComponent());
        }
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public Scope getScope() {
        return new Scope(this.implementation.getJavaScope().getScope());
    }

    public void start() {
        this.componentContextProvider.start();
    }

    public void stop() {
        this.componentContextProvider.stop();
    }

    public InstanceWrapper createInstanceWrapper() {
        return this.componentContextProvider.createInstanceWrapper();
    }

    public boolean isEagerInit() {
        return this.implementation.isEagerInit();
    }

    public long getMaxAge() {
        return this.implementation.getMaxAge();
    }

    public long getMaxIdleTime() {
        return this.implementation.getMaxIdleTime();
    }
}

