/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http;

import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletMappingException;

public class ExtensibleServletHost
implements ServletHost {
    private ServletHostExtensionPoint servletHosts;

    public ExtensibleServletHost(ServletHostExtensionPoint servletHosts) {
        this.servletHosts = servletHosts;
    }

    public void setDefaultPort(int port) {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        for (ServletHost servletHost : this.servletHosts.getServletHosts()) {
            servletHost.setDefaultPort(port);
        }
    }

    private ServletHost getDefaultServletHost() {
        return this.servletHosts.getServletHosts().get(0);
    }

    public int getDefaultPort() {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        return this.getDefaultServletHost().getDefaultPort();
    }

    public void addServletMapping(String uri, Servlet servlet) throws ServletMappingException {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        this.getDefaultServletHost().addServletMapping(uri, servlet);
    }

    public Servlet getServletMapping(String uri) throws ServletMappingException {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        return this.getDefaultServletHost().getServletMapping(uri);
    }

    public Servlet removeServletMapping(String uri) throws ServletMappingException {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        return this.getDefaultServletHost().removeServletMapping(uri);
    }

    public RequestDispatcher getRequestDispatcher(String uri) throws ServletMappingException {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        return this.getDefaultServletHost().getRequestDispatcher(uri);
    }

    public String getContextPath() {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        return this.getDefaultServletHost().getContextPath();
    }

    public URL getURLMapping(String uri) {
        if (this.servletHosts.getServletHosts().isEmpty()) {
            throw new ServletMappingException("No servlet host available");
        }
        return this.getDefaultServletHost().getURLMapping(uri);
    }

    public void setContextPath(String path) {
        this.getDefaultServletHost().setContextPath(path);
    }

    public void setAttribute(String name, Object value) {
        this.getDefaultServletHost().setAttribute(name, value);
    }

    public String getName() {
        return this.getDefaultServletHost().getName();
    }
}

