/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class ClassLoaderDelegate
extends ClassLoader {
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public ClassLoaderDelegate(ClassLoader parent, Collection<ClassLoader> loaders) {
        super(parent);
        if (loaders != null) {
            for (ClassLoader cl : loaders) {
                if (cl == null || cl == parent || this.classLoaders.contains(cl)) continue;
                this.classLoaders.add(cl);
            }
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        for (ClassLoader delegate : this.classLoaders) {
            try {
                return delegate.loadClass(className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    protected URL findResource(String resName) {
        for (ClassLoader delegate : this.classLoaders) {
            URL url = delegate.getResource(resName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String resName) throws IOException {
        HashSet<URL> urlSet = new HashSet<URL>();
        for (ClassLoader delegate : this.classLoaders) {
            Enumeration<URL> urls = delegate.getResources(resName);
            if (urls == null) continue;
            while (urls.hasMoreElements()) {
                urlSet.add(urls.nextElement());
            }
        }
        return Collections.enumeration(urlSet);
    }
}

