/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.json.axiom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;

public class JSONDataSource
implements OMDataSource {
    protected JSONObject json;

    public JSONDataSource(JSONObject json) {
        this.json = json;
    }

    public void serialize(OutputStream outputStream, OMOutputFormat omOutputFormat) throws XMLStreamException {
        try {
            String encoding = omOutputFormat == null ? "UTF-8" : omOutputFormat.getCharSetEncoding();
            outputStream.write(this.getJSONString().getBytes(encoding));
        }
        catch (IOException e) {
            throw new OMException();
        }
    }

    public void serialize(Writer writer, OMOutputFormat omOutputFormat) throws XMLStreamException {
        try {
            writer.write(this.getJSONString());
        }
        catch (IOException e) {
            throw new OMException();
        }
    }

    public void serialize(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        XMLStreamReader reader = this.getReader();
        xmlStreamWriter.writeStartDocument();
        block13: while (reader.hasNext()) {
            int x = reader.next();
            switch (x) {
                case 1: {
                    xmlStreamWriter.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    int namespaceCount = reader.getNamespaceCount();
                    for (int i = namespaceCount - 1; i >= 0; --i) {
                        xmlStreamWriter.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                    int attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        xmlStreamWriter.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    continue block13;
                }
                case 7: {
                    break;
                }
                case 4: {
                    xmlStreamWriter.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    xmlStreamWriter.writeCData(reader.getText());
                    break;
                }
                case 2: {
                    xmlStreamWriter.writeEndElement();
                    break;
                }
                case 8: {
                    xmlStreamWriter.writeEndDocument();
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    xmlStreamWriter.writeComment(reader.getText());
                    break;
                }
                case 11: {
                    xmlStreamWriter.writeDTD(reader.getText());
                    break;
                }
                case 3: {
                    xmlStreamWriter.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 9: {
                    xmlStreamWriter.writeEntityRef(reader.getLocalName());
                    break;
                }
                default: {
                    throw new OMException();
                }
            }
        }
        xmlStreamWriter.writeEndDocument();
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("", "");
        MappedXMLInputFactory inputFactory = new MappedXMLInputFactory(nsMap);
        String jsonString = this.getJSONString();
        return inputFactory.createXMLStreamReader(new JSONTokener(jsonString));
    }

    protected String getJSONString() {
        return this.json.toString();
    }
}

