/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.json.axiom;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.Transformer;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.json.JSONDataBinding;
import org.apache.tuscany.sca.databinding.json.JSONHelper;
import org.apache.tuscany.sca.databinding.json.axiom.JSONBadgerfishDataSource;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.codehaus.jettison.json.JSONObject;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=Transformer.class)
public class JSON2OMElement
extends BaseTransformer<Object, OMElement>
implements PullTransformer<Object, OMElement> {
    private OMFactory factory = OMAbstractFactory.getOMFactory();

    protected Class<Object> getSourceType() {
        return Object.class;
    }

    protected Class<OMElement> getTargetType() {
        return OMElement.class;
    }

    public OMElement transform(Object source, TransformationContext context) {
        try {
            XMLType xmlType;
            DataType dataType;
            Object logical;
            JSONObject json = JSONHelper.toJettison(source);
            if (json == null) {
                return null;
            }
            String ns = JSONDataBinding.ROOT_ELEMENT.getNamespaceURI();
            String name = JSONDataBinding.ROOT_ELEMENT.getLocalPart();
            if (context != null && (logical = (dataType = context.getTargetDataType()).getLogical()) instanceof XMLType && (xmlType = (XMLType)logical).isElement()) {
                ns = xmlType.getElementName().getNamespaceURI();
                name = xmlType.getElementName().getLocalPart();
            }
            JSONBadgerfishDataSource ds = new JSONBadgerfishDataSource(json);
            OMNamespace namespace = this.factory.createOMNamespace(ns, "");
            return this.factory.createOMElement((OMDataSource)ds, name, namespace);
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    public int getWeight() {
        return 500;
    }

    public String getSourceDataBinding() {
        return "JSON";
    }
}

