/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.json;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.json.JSONHelper;
import org.apache.tuscany.sca.databinding.xml.XMLStreamSerializer;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamReader2JSON
extends BaseTransformer<XMLStreamReader, Object>
implements PullTransformer<XMLStreamReader, Object> {
    protected Class<XMLStreamReader> getSourceType() {
        return XMLStreamReader.class;
    }

    protected Class<Object> getTargetType() {
        return Object.class;
    }

    public Object transform(XMLStreamReader source, TransformationContext context) {
        try {
            StringWriter writer = new StringWriter();
            BadgerFishXMLStreamWriter jsonWriter = new BadgerFishXMLStreamWriter((Writer)writer);
            XMLStreamSerializer serializer = new XMLStreamSerializer();
            serializer.serialize(source, (XMLStreamWriter)jsonWriter);
            source.close();
            Class type = null;
            if (context != null && context.getTargetDataType() != null) {
                type = context.getTargetDataType().getPhysical();
            }
            return JSONHelper.toJSON(writer.toString(), type);
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    public int getWeight() {
        return 500;
    }

    public String getTargetDataBinding() {
        return "JSON";
    }
}

