/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.json;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.impl.BaseDataBinding;
import org.apache.tuscany.sca.databinding.json.JSONHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.codehaus.jettison.json.JSONObject;

public class JSONDataBinding
extends BaseDataBinding {
    public static final String NAME = "JSON";
    public static final String ROOT_NAMESPACE = "http://tuscany.apache.org/xmlns/sca/databinding/json/1.0";
    public static final QName ROOT_ELEMENT = new QName("http://tuscany.apache.org/xmlns/sca/databinding/json/1.0", "root");

    public JSONDataBinding() {
        super(NAME, org.json.JSONObject.class);
    }

    public boolean introspect(DataType type, Operation operation) {
        assert (type != null);
        Class cls = type.getPhysical();
        if (JSONObject.class.isAssignableFrom(cls) || org.json.JSONObject.class.isAssignableFrom(cls)) {
            type.setDataBinding(this.getName());
            if (type.getLogical() == null) {
                type.setLogical((Object)XMLType.UNKNOWN);
            }
            return true;
        }
        return false;
    }

    public Object copy(Object arg, DataType dataType, Operation operation) {
        if (arg == null) {
            return null;
        }
        try {
            Class<?> type = arg != null ? arg.getClass() : null;
            return JSONHelper.toJSON(arg.toString(), type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

