/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.databinding.xml.WrappingXMLStreamReader;
import org.apache.tuscany.sca.databinding.xml.XmlNode;
import org.apache.tuscany.sca.databinding.xml.XmlNodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTreeStreamReaderImpl
implements XMLStreamReader {
    protected int state;
    protected XmlNodeIterator iterator;
    protected XmlNode current;
    protected XMLStreamReader reader;

    public XmlTreeStreamReaderImpl(XmlNode root) {
        this.iterator = new XmlNodeIterator(root);
        this.current = null;
        this.state = 7;
        this.reader = null;
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private void checkElementState() {
        if (this.getEventType() != 1 && this.getEventType() != 2) {
            throw new IllegalStateException();
        }
    }

    private List<XmlNode> getAttributes() {
        if (this.current != null && this.current.attributes() != null) {
            return this.current.attributes();
        }
        return Collections.emptyList();
    }

    @Override
    public int getAttributeCount() {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributeCount();
        }
        return this.getAttributes().size();
    }

    @Override
    public String getAttributeLocalName(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributeLocalName(i);
        }
        return this.getAttributes().get(i).getName().getLocalPart();
    }

    @Override
    public QName getAttributeName(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributeName(i);
        }
        return this.getAttributes().get(i).getName();
    }

    @Override
    public String getAttributeNamespace(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributeNamespace(i);
        }
        return this.getAttributes().get(i).getName().getNamespaceURI();
    }

    @Override
    public String getAttributePrefix(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributePrefix(i);
        }
        return this.getAttributes().get(i).getName().getPrefix();
    }

    @Override
    public String getAttributeType(int i) {
        if (this.reader != null) {
            return this.reader.getAttributeType(i);
        }
        return null;
    }

    @Override
    public String getAttributeValue(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributeValue(i);
        }
        return (String)this.getAttributes().get(i).getValue();
    }

    @Override
    public String getAttributeValue(String nsUri, String localName) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getAttributeValue(nsUri, localName);
        }
        int count = this.getAttributeCount();
        String value = null;
        for (int i = 0; i < count; ++i) {
            QName attrQName = this.getAttributeName(i);
            if (nsUri == null) {
                if (!localName.equals(attrQName.getLocalPart())) continue;
                value = this.getAttributeValue(i);
                break;
            }
            if (!localName.equals(attrQName.getLocalPart()) || !nsUri.equals(attrQName.getNamespaceURI())) continue;
            value = this.getAttributeValue(i);
            break;
        }
        return value;
    }

    @Override
    public String getCharacterEncodingScheme() {
        if (this.reader != null) {
            return this.reader.getCharacterEncodingScheme();
        }
        return "UTF-8";
    }

    @Override
    public String getElementText() throws XMLStreamException {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getElementText();
        }
        return (String)this.current.getValue();
    }

    @Override
    public String getEncoding() {
        if (this.reader != null) {
            return this.reader.getEncoding();
        }
        return "UTF-8";
    }

    @Override
    public int getEventType() {
        return this.state;
    }

    @Override
    public String getLocalName() {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getLocalName();
        }
        return this.current.getName().getLocalPart();
    }

    @Override
    public Location getLocation() {
        if (this.reader != null) {
            return this.reader.getLocation();
        }
        return new Location(){

            public int getCharacterOffset() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getLineNumber() {
                return 0;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getName();
        }
        return this.current.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.reader != null) {
            return this.reader.getNamespaceContext();
        }
        return this.iterator.getNamespaceContext();
    }

    private Map<String, String> getNamespaces() {
        if (this.current != null && this.current.namespaces() != null) {
            return this.current.namespaces();
        }
        return Collections.emptyMap();
    }

    @Override
    public int getNamespaceCount() {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getNamespaceCount();
        }
        return this.getNamespaces().size();
    }

    @Override
    public String getNamespacePrefix(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getNamespacePrefix(i);
        }
        return new ArrayList<Map.Entry<String, String>>(this.getNamespaces().entrySet()).get(i).getKey();
    }

    @Override
    public String getNamespaceURI() {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getNamespaceURI();
        }
        return this.current.getName().getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int i) {
        this.checkElementState();
        if (this.reader != null) {
            return this.reader.getNamespaceURI(i);
        }
        return new ArrayList<Map.Entry<String, String>>(this.getNamespaces().entrySet()).get(i).getValue();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.reader != null) {
            return this.reader.getNamespaceURI(prefix);
        }
        return this.getNamespaceContext().getNamespaceURI(prefix);
    }

    @Override
    public String getPIData() {
        if (this.reader != null) {
            return this.reader.getPIData();
        }
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    @Override
    public String getPITarget() {
        if (this.reader != null) {
            return this.reader.getPITarget();
        }
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    @Override
    public String getPrefix() {
        if (this.reader != null) {
            return this.reader.getPrefix();
        }
        if (this.state == 1 || this.state == 2) {
            String prefix = this.current.getName().getPrefix();
            return "".equals(prefix) ? null : prefix;
        }
        if (this.state == 7) {
            return null;
        }
        throw new IllegalStateException("State==" + this.state);
    }

    @Override
    public Object getProperty(String key) throws IllegalArgumentException {
        if (this.reader != null) {
            return this.reader.getProperty(key);
        }
        return null;
    }

    @Override
    public String getText() {
        if (this.reader != null) {
            return this.reader.getText();
        }
        return (String)this.current.getValue();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.reader != null) {
            return this.reader.getTextCharacters();
        }
        String value = (String)this.current.getValue();
        return value == null ? new char[]{} : value.toCharArray();
    }

    private int copy(int sourceStart, char[] target, int targetStart, int length) {
        char[] source = this.getTextCharacters();
        if (sourceStart > source.length) {
            throw new IndexOutOfBoundsException("source start > source length");
        }
        int sourceLen = source.length - sourceStart;
        if (length > sourceLen) {
            length = sourceLen;
        }
        System.arraycopy(source, sourceStart, target, targetStart, length);
        return sourceLen;
    }

    @Override
    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        if (this.reader != null) {
            return this.reader.getTextCharacters(i, chars, i1, i2);
        }
        return this.copy(i, chars, i1, i2);
    }

    @Override
    public int getTextLength() {
        if (this.reader != null) {
            return this.reader.getTextLength();
        }
        return this.getTextCharacters().length;
    }

    @Override
    public int getTextStart() {
        if (this.reader != null) {
            return this.reader.getTextStart();
        }
        return 0;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public boolean hasName() {
        if (this.reader != null) {
            return this.reader.hasName();
        }
        return this.current.getName() != null;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.iterator.hasNext() || this.state != 8 || this.reader != null && this.reader.hasNext();
    }

    @Override
    public boolean hasText() {
        if (this.reader != null) {
            return this.reader.hasText();
        }
        return this.current.getType() == XmlNode.Type.CHARACTERS;
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        if (this.reader != null) {
            return this.reader.isAttributeSpecified(i);
        }
        return false;
    }

    @Override
    public boolean isCharacters() {
        if (this.reader != null) {
            return this.reader.isCharacters();
        }
        return this.current.getType() == XmlNode.Type.CHARACTERS;
    }

    @Override
    public boolean isEndElement() {
        if (this.reader != null) {
            return this.reader.isEndElement();
        }
        return this.getEventType() == 2;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isStartElement() {
        if (this.reader != null) {
            return this.reader.isStartElement();
        }
        return this.getEventType() == 1;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.reader != null) {
            return this.reader.isWhiteSpace();
        }
        return false;
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more events");
        }
        if (this.reader != null) {
            if (!this.reader.hasNext()) {
                this.reader = null;
            } else {
                this.state = this.reader.next();
                return this.state;
            }
        }
        if (!this.iterator.hasNext()) {
            this.state = 8;
            this.current = null;
            return this.state;
        }
        this.current = this.iterator.next();
        XmlNode.Type type = this.current.getType();
        int itState = this.iterator.getState();
        if (itState == 1) {
            this.state = type == XmlNode.Type.ELEMENT ? 2 : this.next();
        }
        if (itState == 0) {
            if (type == XmlNode.Type.ELEMENT) {
                this.state = 1;
            } else if (type == XmlNode.Type.CHARACTERS) {
                this.state = 4;
            } else if (type == XmlNode.Type.READER) {
                XMLStreamReader value = (XMLStreamReader)this.current.getValue();
                this.reader = new WrappingXMLStreamReader(value);
                this.state = this.reader.getEventType();
                return this.state;
            }
        }
        return this.state;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int event;
        while ((event = this.next()) != 1 && event != 2) {
        }
        return event;
    }

    @Override
    public void require(int i, String ns, String localPart) throws XMLStreamException {
        if (this.reader != null) {
            this.reader.require(i, ns, localPart);
            return;
        }
        int event = this.getEventType();
        if (event != i) {
            throw new IllegalStateException("Event type is " + event + " (!=" + i + ")");
        }
        QName name = this.getName();
        String ns1 = name.getNamespaceURI();
        String localName1 = name.getLocalPart();
        if (ns != null && !ns.equals(ns1)) {
            throw new IllegalStateException("Namespace URI is " + ns1 + " (!=" + ns + ")");
        }
        if (localPart != null && !localPart.equals(localName1)) {
            throw new IllegalStateException("Local name is " + localName1 + " (!=" + localPart + ")");
        }
    }

    @Override
    public boolean standaloneSet() {
        return true;
    }
}

