/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.tuscany.sca.databinding.xml.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlNodeIterator
implements Iterator<XmlNode> {
    public static final int START = 0;
    public static final int END = 1;
    protected FastStack<ElementHolder> stack;
    protected int state;
    protected NamespaceContextImpl nsContext;

    public XmlNodeIterator(XmlNode rootNode) {
        ArrayList<XmlNode> v = new ArrayList<XmlNode>(1);
        v.add(rootNode);
        this.stack = new FastStack();
        Iterator<XmlNode> i = v.iterator();
        this.stack.push(new ElementHolder(null, i));
        this.state = 0;
        this.nsContext = new NamespaceContextImpl(null);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.empty() && (this.state != 1 || this.stack.peek().parent != null);
    }

    @Override
    public XmlNode next() {
        this.state = 0;
        ElementHolder element = this.stack.peek();
        Iterator it = element.children;
        if (it == null || !it.hasNext()) {
            this.stack.pop();
            this.state = 1;
            this.nsContext = (NamespaceContextImpl)this.nsContext.getParent();
            return element.parent;
        }
        XmlNode node = (XmlNode)it.next();
        this.stack.push(new ElementHolder(node, node.children()));
        this.nsContext = new NamespaceContextImpl(this.nsContext);
        this.populateNamespaces(node);
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getState() {
        return this.state;
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    private void populateNamespaces(XmlNode element) {
        if (element.getName() != null && element.namespaces() != null) {
            for (Map.Entry<String, String> e : element.namespaces().entrySet()) {
                this.nsContext.register(e.getKey(), e.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastStack<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 2130079159931574599L;

        public FastStack() {
        }

        public FastStack(int initialSize) {
            super(initialSize);
        }

        public boolean empty() {
            return this.isEmpty();
        }

        public T peek() throws EmptyStackException {
            int n = this.size();
            if (n <= 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(n - 1);
        }

        public T peek(int n) throws EmptyStackException {
            int m = this.size() - n - 1;
            if (m < 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(m);
        }

        public T pop() throws EmptyStackException {
            int n = this.size();
            if (n <= 0) {
                throw new EmptyStackException();
            }
            return (T)this.remove(n - 1);
        }

        public Object push(T item) {
            this.add(item);
            return item;
        }

        public int search(T object) {
            for (int i = this.size() - 1; i >= 0; --i) {
                Object current = this.get(i);
                if ((object != null || current != null) && (object == null || !object.equals(current))) continue;
                return i;
            }
            return -1;
        }

        public T get() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(size - 1);
        }

        public T remove() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return (T)this.remove(size - 1);
        }
    }

    private static class NamespaceContextImpl
    implements NamespaceContext {
        private NamespaceContext parent;
        private Map<String, String> map = new HashMap<String, String>();

        public NamespaceContextImpl(NamespaceContext parent) {
            this.parent = parent;
            if (parent == null) {
                this.map.put("xml", "http://www.w3.org/XML/1998/namespace");
                this.map.put("xmlns", "http://www.w3.org/2000/xmlns/");
            }
        }

        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Prefix is null");
            }
            String ns = this.map.get(prefix);
            if (ns != null) {
                return ns;
            }
            if (this.parent != null) {
                return this.parent.getNamespaceURI(prefix);
            }
            return null;
        }

        public String getPrefix(String nsURI) {
            if (nsURI == null) {
                throw new IllegalArgumentException("Namespace is null");
            }
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                if (!entry.getValue().equals(nsURI)) continue;
                return entry.getKey();
            }
            if (this.parent != null) {
                return this.parent.getPrefix(nsURI);
            }
            return null;
        }

        public Iterator getPrefixes(String nsURI) {
            ArrayList<String> prefixList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                if (!entry.getValue().equals(nsURI)) continue;
                prefixList.add(entry.getKey());
            }
            final Iterator currentIterator = prefixList.iterator();
            final Iterator<String> parentIterator = this.parent != null ? null : this.parent.getPrefixes(nsURI);
            return new Iterator(){

                public boolean hasNext() {
                    return currentIterator.hasNext() || parentIterator != null && parentIterator.hasNext();
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException("End of iterator has reached");
                    }
                    return currentIterator.hasNext() ? currentIterator.next() : parentIterator.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void register(String prefix, String ns) {
            this.map.put(prefix, ns);
        }

        public NamespaceContext getParent() {
            return this.parent;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.map.toString());
            if (this.parent != null) {
                sb.append("\nParent: ");
                sb.append(this.parent);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementHolder {
        private XmlNode parent;
        private Iterator<XmlNode> children;

        public ElementHolder(XmlNode parent, Iterator<XmlNode> children) {
            this.parent = parent;
            this.children = children;
        }
    }
}

