/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.xml.SAX2DOMPipe;
import org.apache.tuscany.sca.databinding.xml.XMLStreamReader2SAX;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamReader2Node
extends BaseTransformer<XMLStreamReader, Node>
implements PullTransformer<XMLStreamReader, Node> {
    private XMLStreamReader2SAX stax2sax = new XMLStreamReader2SAX();

    @Override
    public Node transform(XMLStreamReader source, TransformationContext context) {
        try {
            DataPipe<ContentHandler, Node> pipe = new SAX2DOMPipe().newInstance();
            this.stax2sax.transform(source, pipe.getSink(), context);
            Node node = pipe.getResult();
            source.close();
            if (node instanceof Document) {
                Document doc = (Document)node;
                return DOMHelper.adjustElementName(context, doc.getDocumentElement());
            }
            return node;
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<XMLStreamReader> getSourceType() {
        return XMLStreamReader.class;
    }

    @Override
    protected Class<Node> getTargetType() {
        return Node.class;
    }

    @Override
    public int getWeight() {
        return 40;
    }
}

