/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.DataPipeTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.Transformer;
import org.apache.tuscany.sca.databinding.TransformerExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.TransformationContextImpl;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediatorImpl
implements Mediator {
    private DataBindingExtensionPoint dataBindings;
    private TransformerExtensionPoint transformers;

    public MediatorImpl(DataBindingExtensionPoint dataBindings, TransformerExtensionPoint transformers) {
        this.dataBindings = dataBindings;
        this.transformers = transformers;
    }

    @Override
    public Object mediate(Object source, DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        if ((sourceDataType == null || sourceDataType.getDataBinding() == null) && source != null) {
            Operation operation = (Operation)metadata.get("source.operation");
            sourceDataType = this.dataBindings.introspectType(source, operation);
        }
        if (sourceDataType == null || targetDataType == null) {
            return source;
        }
        if (sourceDataType.equals(targetDataType)) {
            return source;
        }
        List<Transformer> path = this.getTransformerChain(sourceDataType, targetDataType);
        Object result = source;
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            Transformer transformer = path.get(i);
            TransformationContext context = this.createTransformationContext(sourceDataType, targetDataType, size, i, transformer, metadata);
            if (transformer instanceof PullTransformer) {
                result = ((PullTransformer)transformer).transform(result, context);
                continue;
            }
            if (!(transformer instanceof PushTransformer)) continue;
            DataPipeTransformer dataPipeFactory = i < size - 1 ? (DataPipeTransformer)path.get(++i) : null;
            DataPipe dataPipe = dataPipeFactory == null ? null : dataPipeFactory.newInstance();
            ((PushTransformer)transformer).transform(result, dataPipe.getSink(), context);
            result = dataPipe.getResult();
        }
        return result;
    }

    private TransformationContext createTransformationContext(DataType sourceDataType, DataType targetDataType, int size, int index, Transformer transformer, Map<String, Object> metadata) {
        DataType sourceType = index == 0 ? sourceDataType : new DataTypeImpl(transformer.getSourceDataBinding(), Object.class, sourceDataType.getLogical());
        DataType targetType = index == size - 1 ? targetDataType : new DataTypeImpl(transformer.getTargetDataBinding(), Object.class, targetDataType.getLogical());
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        TransformationContextImpl context = new TransformationContextImpl(sourceType, targetType, classLoader, metadata);
        return context;
    }

    @Override
    public void mediate(Object source, Object target, DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        if (source == null) {
            return;
        }
        if (sourceDataType == null || sourceDataType.getDataBinding() == null) {
            Operation operation = (Operation)metadata.get("source.operation");
            sourceDataType = this.dataBindings.introspectType(source, operation);
        }
        if (sourceDataType == null) {
            return;
        }
        if (sourceDataType.equals(targetDataType)) {
            return;
        }
        List<Transformer> path = this.getTransformerChain(sourceDataType, targetDataType);
        Object result = source;
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            Transformer transformer = path.get(i);
            TransformationContext context = this.createTransformationContext(sourceDataType, targetDataType, size, i, transformer, metadata);
            if (transformer instanceof PullTransformer) {
                result = ((PullTransformer)transformer).transform(result, context);
                continue;
            }
            if (!(transformer instanceof PushTransformer)) continue;
            DataPipeTransformer dataPipeFactory = i < size - 1 ? (DataPipeTransformer)path.get(++i) : null;
            DataPipe dataPipe = dataPipeFactory == null ? null : dataPipeFactory.newInstance();
            Object sink = dataPipe != null ? dataPipe.getSink() : target;
            ((PushTransformer)transformer).transform(result, sink, context);
            result = dataPipe != null ? dataPipe.getResult() : null;
        }
    }

    private List<Transformer> getTransformerChain(DataType sourceDataType, DataType targetDataType) {
        String targetId;
        String sourceId = sourceDataType.getDataBinding();
        List<Transformer> path = this.transformers.getTransformerChain(sourceId, targetId = targetDataType.getDataBinding());
        if (path == null) {
            TransformationException ex = new TransformationException("No path found for the transformation: " + sourceId + "->" + targetId);
            ex.setSourceDataBinding(sourceId);
            ex.setTargetDataBinding(targetId);
            throw ex;
        }
        return path;
    }

    @Override
    public DataBindingExtensionPoint getDataBindings() {
        return this.dataBindings;
    }

    @Override
    public TransformerExtensionPoint getTransformers() {
        return this.transformers;
    }
}

