/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.tuscany.sca.databinding.impl.BaseDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupDataBinding
extends BaseDataBinding {
    public static final String NAME = "databinding:group";
    protected Class[] markerTypes;

    public GroupDataBinding(Class[] types) {
        super(NAME, GroupDataBinding.class);
        this.markerTypes = types;
    }

    @Override
    public boolean introspect(DataType type, Operation operation) {
        if (this.markerTypes == null) {
            return false;
        }
        Type physical = type.getPhysical();
        if (physical instanceof ParameterizedType) {
            physical = ((ParameterizedType)physical).getRawType();
        }
        if (!(physical instanceof Class)) {
            return false;
        }
        Type cls = physical;
        for (Class c : this.markerTypes) {
            if (!this.isTypeOf(c, (Class<?>)cls)) continue;
            type.setDataBinding(this.getDataBinding(c));
            Object logical = this.getLogical((Class<?>)cls, null);
            if (logical != null) {
                type.setLogical(this.getLogical((Class<?>)cls, null));
            } else {
                type.setLogical((Object)XMLType.UNKNOWN);
            }
            return true;
        }
        return false;
    }

    protected boolean isTypeOf(Class<?> markerType, Class<?> type) {
        return markerType.isAssignableFrom(type);
    }

    protected String getDataBinding(Class<?> baseType) {
        return baseType.getName();
    }

    protected abstract Object getLogical(Class<?> var1, Operation var2);
}

