/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.Transformer;
import org.apache.tuscany.sca.databinding.TransformerExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.DirectedGraph;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransformerExtensionPoint
implements TransformerExtensionPoint {
    private static final Logger logger = Logger.getLogger(DefaultTransformerExtensionPoint.class.getName());
    private boolean loadedTransformers;
    private final DirectedGraph<Object, Transformer> graph = new DirectedGraph();

    @Override
    public void addTransformer(String sourceType, String resultType, int weight, Transformer transformer, boolean publicTransformer) {
        if (logger.isLoggable(Level.FINE)) {
            String className = transformer.getClass().getName();
            boolean lazy = false;
            boolean pull = transformer instanceof PullTransformer;
            if (transformer instanceof LazyPullTransformer) {
                className = ((LazyPullTransformer)transformer).transformerDeclaration.getClassName();
                lazy = true;
            }
            if (transformer instanceof LazyPushTransformer) {
                className = ((LazyPushTransformer)transformer).transformerDeclaration.getClassName();
                lazy = true;
            }
            logger.fine("Adding transformer: " + className + ";source=" + sourceType + ",target=" + resultType + ",weight=" + weight + ",type=" + (pull ? "pull" : "push") + ",lazy=" + lazy);
        }
        this.graph.addEdge(sourceType, resultType, transformer, weight, publicTransformer);
    }

    @Override
    public void addTransformer(Transformer transformer, boolean publicTransformer) {
        this.addTransformer(transformer.getSourceDataBinding(), transformer.getTargetDataBinding(), transformer.getWeight(), transformer, publicTransformer);
    }

    @Override
    public boolean removeTransformer(String sourceType, String resultType) {
        return this.graph.removeEdge(sourceType, resultType);
    }

    @Override
    public Transformer getTransformer(String sourceType, String resultType) {
        this.loadTransformers();
        DirectedGraph.Edge edge = this.graph.getEdge(sourceType, resultType);
        return edge == null ? null : (Transformer)edge.getValue();
    }

    private synchronized void loadTransformers() {
        if (this.loadedTransformers) {
            return;
        }
        this.loadedTransformers = true;
        this.loadTransformers(PullTransformer.class);
        this.loadTransformers(PushTransformer.class);
    }

    private void loadTransformers(Class<?> transformerClass) {
        Set transformerDeclarations;
        try {
            transformerDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(transformerClass);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration transformerDeclaration : transformerDeclarations) {
            Map attributes = transformerDeclaration.getAttributes();
            String source = (String)attributes.get("source");
            String target = (String)attributes.get("target");
            int weight = Integer.valueOf((String)attributes.get("weight"));
            String b = (String)attributes.get("public");
            boolean pub = true;
            if (b != null) {
                pub = Boolean.valueOf(b);
            }
            Transformer transformer = transformerClass == PullTransformer.class ? new LazyPullTransformer(source, target, weight, transformerDeclaration) : new LazyPushTransformer(source, target, weight, transformerDeclaration);
            this.addTransformer(transformer, pub);
        }
    }

    @Override
    public List<Transformer> getTransformerChain(String sourceType, String resultType) {
        this.loadTransformers();
        String source = sourceType;
        String result = resultType;
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        DirectedGraph.Edge link = this.graph.getEdge(sourceType, resultType);
        if (link != null) {
            transformers.add((Transformer)link.getValue());
        } else {
            DirectedGraph.Path path = this.graph.getShortestPath(source, result);
            if (path == null) {
                return null;
            }
            for (DirectedGraph.Edge edge : path.getEdges()) {
                transformers.add((Transformer)edge.getValue());
            }
        }
        return transformers;
    }

    public String toString() {
        this.loadTransformers();
        return this.graph.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyPushTransformer
    implements PushTransformer<Object, Object> {
        private String source;
        private String target;
        private int weight;
        private ServiceDeclaration transformerDeclaration;
        private PushTransformer<Object, Object> transformer;

        public LazyPushTransformer(String source, String target, int weight, ServiceDeclaration transformerDeclaration) {
            this.source = source;
            this.target = target;
            this.weight = weight;
            this.transformerDeclaration = transformerDeclaration;
        }

        private PushTransformer<Object, Object> getTransformer() {
            if (this.transformer == null) {
                try {
                    Class transformerClass = this.transformerDeclaration.loadClass();
                    Constructor constructor = transformerClass.getConstructor(new Class[0]);
                    this.transformer = (PushTransformer)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.transformer;
        }

        @Override
        public String getSourceDataBinding() {
            return this.source;
        }

        @Override
        public String getTargetDataBinding() {
            return this.target;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public void transform(Object source, Object sink, TransformationContext context) {
            this.getTransformer().transform(source, sink, context);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(";className=").append(this.transformerDeclaration.getClassName());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyPullTransformer
    implements PullTransformer<Object, Object> {
        private String source;
        private String target;
        private int weight;
        private ServiceDeclaration transformerDeclaration;
        private PullTransformer<Object, Object> transformer;

        public LazyPullTransformer(String source, String target, int weight, ServiceDeclaration transformerDeclaration) {
            this.source = source;
            this.target = target;
            this.weight = weight;
            this.transformerDeclaration = transformerDeclaration;
        }

        private PullTransformer<Object, Object> getTransformer() {
            if (this.transformer == null) {
                try {
                    Class transformerClass = this.transformerDeclaration.loadClass();
                    Constructor constructor = transformerClass.getConstructor(new Class[0]);
                    this.transformer = (PullTransformer)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.transformer;
        }

        @Override
        public String getSourceDataBinding() {
            return this.source;
        }

        @Override
        public String getTargetDataBinding() {
            return this.target;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public Object transform(Object source, TransformationContext context) {
            return this.getTransformer().transform(source, context);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(";className=").append(this.transformerDeclaration.getClassName());
            return sb.toString();
        }
    }
}

