/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.provider;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.provider.DefinitionsProvider;
import org.apache.tuscany.sca.provider.DefinitionsProviderExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDefinitionsProviderExtensionPoint
implements DefinitionsProviderExtensionPoint {
    private ExtensionPointRegistry extensionPointRegistry = null;
    private boolean loaded;
    private List<DefinitionsProvider> scaDefnsProviders = new ArrayList<DefinitionsProvider>();

    public DefaultDefinitionsProviderExtensionPoint(ExtensionPointRegistry extnPtReg) {
        this.extensionPointRegistry = extnPtReg;
    }

    @Override
    public void addDefinitionsProvider(DefinitionsProvider provider) {
        this.scaDefnsProviders.add(provider);
    }

    @Override
    public void removeDefinitionsProvider(DefinitionsProvider provider) {
        this.scaDefnsProviders.remove(provider);
    }

    @Override
    public List<DefinitionsProvider> getDefinitionsProviders() {
        this.loadProviders();
        return this.scaDefnsProviders;
    }

    private synchronized void loadProviders() {
        if (this.loaded) {
            return;
        }
        DefinitionsProvider aProvider = null;
        Class providerClass = null;
        Constructor constructor = null;
        try {
            Set defnProviderDecls = ServiceDiscovery.getInstance().getServiceDeclarations(DefinitionsProvider.class.getName());
            for (ServiceDeclaration aDefnProviderDecl : defnProviderDecls) {
                providerClass = aDefnProviderDecl.loadClass();
                try {
                    constructor = providerClass.getConstructor(new Class[0]);
                    aProvider = (DefinitionsProvider)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    constructor = providerClass.getConstructor(ExtensionPointRegistry.class);
                    aProvider = (DefinitionsProvider)constructor.newInstance(this.extensionPointRegistry);
                }
                this.scaDefnsProviders.add(aProvider);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }
}

