/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.context;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContextFactoryExtensionPoint
implements ContextFactoryExtensionPoint {
    private HashMap<Class<?>, Object> factories = new HashMap();
    private ExtensionPointRegistry registry;

    public DefaultContextFactoryExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addFactory(Object factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot add null as a factory");
        }
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.factories.put(interfaces[i], factory);
            ++i;
        }
    }

    @Override
    public void removeFactory(Object factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot remove null as a factory");
        }
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.factories.remove(interfaces[i]);
            ++i;
        }
    }

    @Override
    public <T> T getFactory(Class<T> factoryInterface) throws IllegalArgumentException {
        if (factoryInterface == null) {
            throw new IllegalArgumentException("Cannot get null as a factory");
        }
        Object factory = this.factories.get(factoryInterface);
        if (factory == null) {
            try {
                ServiceDeclaration factoryDeclaration = ServiceDiscovery.getInstance().getFirstServiceDeclaration(factoryInterface.getName());
                if (factoryDeclaration != null) {
                    Class factoryClass = factoryDeclaration.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    factory = constructor.newInstance(this.registry);
                    this.addFactory(factory);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return factoryInterface.cast(factory);
    }
}

