/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.databinding.wire.DataTransformationInterceptor;
import org.apache.tuscany.sca.core.databinding.wire.PassByValueInterceptor;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;

public class DataBindingRuntimeWireProcessor
implements RuntimeWireProcessor {
    private Mediator mediator;

    public DataBindingRuntimeWireProcessor(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public boolean isTransformationRequired(DataType source, DataType target) {
        String targetDataBinding;
        if (source == null || target == null) {
            return false;
        }
        if (source == target) {
            return false;
        }
        if (source == null && target == null) {
            return false;
        }
        if (source == null || target == null) {
            return true;
        }
        String sourceDataBinding = source.getDataBinding();
        if (sourceDataBinding == (targetDataBinding = target.getDataBinding())) {
            return false;
        }
        if (sourceDataBinding == null || targetDataBinding == null) {
            return false;
        }
        return !sourceDataBinding.equals(targetDataBinding);
    }

    public boolean isTransformationRequired(Operation source, Operation target) {
        if (source == target) {
            return false;
        }
        if (source.isWrapperStyle() != target.isWrapperStyle()) {
            return true;
        }
        DataType sourceOutputType = source.getOutputType();
        DataType targetOutputType = target.getOutputType();
        if (this.isTransformationRequired(targetOutputType, sourceOutputType)) {
            return true;
        }
        List sourceInputType = (List)source.getInputType().getLogical();
        List targetInputType = (List)target.getInputType().getLogical();
        int size = sourceInputType.size();
        if (size != targetInputType.size()) {
            return true;
        }
        int i = 0;
        while (i < size) {
            if (this.isTransformationRequired((DataType)sourceInputType.get(i), (DataType)targetInputType.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isTransformationRequired(InterfaceContract sourceContract, Operation sourceOperation, InterfaceContract targetContract, Operation targetOperation) {
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (sourceContract == targetContract) {
            return false;
        }
        return this.isTransformationRequired(sourceOperation, targetOperation);
    }

    public void process(RuntimeWire wire) {
        InterfaceContract sourceContract = wire.getEndpointReference().getInterfaceContract();
        InterfaceContract targetContract = wire.getEndpoint().getInterfaceContract();
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (!sourceContract.getInterface().isRemotable()) {
            return;
        }
        List chains = wire.getInvocationChains();
        for (InvocationChain chain : chains) {
            Operation sourceOperation = chain.getSourceOperation();
            Operation targetOperation = chain.getTargetOperation();
            Object interceptor = null;
            if (this.isTransformationRequired(sourceContract, sourceOperation, targetContract, targetOperation)) {
                interceptor = new DataTransformationInterceptor(wire, sourceOperation, targetOperation, this.mediator);
            } else if (!this.isOnMessage(targetOperation) && this.isRemotable(chain, sourceOperation, targetOperation)) {
                interceptor = new PassByValueInterceptor(this.mediator, chain, targetOperation);
            }
            if (interceptor == null) continue;
            String phase = wire.getEndpointReference().getReference() instanceof ComponentReference ? "reference.interface" : "service.interface";
            chain.addInterceptor(phase, (Interceptor)interceptor);
        }
    }

    protected boolean isOnMessage(Operation op) {
        return "onMessage".equals(op.getName());
    }

    protected boolean isRemotable(InvocationChain chain, Operation sourceOperation, Operation targetOperation) {
        if (!sourceOperation.getInterface().isRemotable()) {
            return false;
        }
        return targetOperation.getInterface().isRemotable();
    }
}

