/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output2OutputTransformer
extends BaseTransformer<Object, Object>
implements PullTransformer<Object, Object> {
    protected Mediator mediator;

    public Output2OutputTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return "idl:output";
    }

    public String getTargetDataBinding() {
        return "idl:output";
    }

    protected Class<Object> getSourceType() {
        return Object.class;
    }

    protected Class<Object> getTargetType() {
        return Object.class;
    }

    public int getWeight() {
        return 10;
    }

    private String getDataBinding(Operation operation) {
        WrapperInfo wrapper = operation.getWrapper();
        if (wrapper != null) {
            return wrapper.getDataBinding();
        }
        return null;
    }

    private WrapperHandler getWrapperHandler(String dataBindingId, boolean required) {
        WrapperHandler wrapperHandler = null;
        if (dataBindingId != null) {
            DataBinding dataBinding = this.mediator.getDataBindings().getDataBinding(dataBindingId);
            WrapperHandler wrapperHandler2 = wrapperHandler = dataBinding == null ? null : dataBinding.getWrapperHandler();
        }
        if (wrapperHandler == null && required) {
            throw new TransformationException("No wrapper handler is provided for databinding: " + dataBindingId);
        }
        return wrapperHandler;
    }

    private boolean matches(WrapperInfo w1, WrapperInfo w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        if (!w1.getOutputWrapperElement().equals((Object)w2.getOutputWrapperElement())) {
            return false;
        }
        List list1 = w1.getOutputChildElements();
        List list2 = w2.getOutputChildElements();
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            String n2;
            String n1 = ((ElementInfo)list1.get(i)).getQName().getLocalPart();
            if (!n1.equals(n2 = ((ElementInfo)list2.get(i)).getQName().getLocalPart())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object transform(Object response, TransformationContext context) {
        Object sourceWrapper;
        WrapperHandler targetWrapperHandler;
        Operation targetOp;
        DataType targetType;
        WrapperHandler sourceWrapperHandler;
        Operation sourceOp;
        DataType sourceType;
        block12: {
            try {
                sourceType = context.getSourceDataType();
                sourceOp = context.getSourceOperation();
                boolean sourceWrapped = sourceOp != null && sourceOp.isWrapperStyle() && sourceOp.getWrapper() != null;
                boolean sourceBare = sourceOp != null && !sourceOp.isWrapperStyle() && sourceOp.getWrapper() == null;
                sourceWrapperHandler = null;
                String sourceDataBinding = this.getDataBinding(sourceOp);
                sourceWrapperHandler = this.getWrapperHandler(sourceDataBinding, sourceWrapped);
                targetType = context.getTargetDataType();
                targetOp = context.getTargetOperation();
                boolean targetWrapped = targetOp != null && targetOp.isWrapperStyle() && targetOp.getWrapper() != null;
                boolean targetBare = targetOp != null && !targetOp.isWrapperStyle() && targetOp.getWrapper() == null;
                targetWrapperHandler = null;
                String targetDataBinding = this.getDataBinding(targetOp);
                targetWrapperHandler = this.getWrapperHandler(targetDataBinding, targetWrapped);
                if (!sourceWrapped && !sourceBare && targetWrapped) {
                    WrapperInfo wrapper = targetOp.getWrapper();
                    wrapper.getOutputWrapperElement();
                    List childElements = wrapper.getOutputChildElements();
                    if (wrapper != null) {
                        wrapper.getOutputWrapperClass();
                    }
                    if (sourceWrapperHandler != null) {
                        DataType sourceWrapperType;
                        WrapperInfo sourceWrapperInfo = sourceOp.getWrapper();
                        DataType dataType = sourceWrapperType = sourceWrapperInfo != null ? sourceWrapperInfo.getOutputWrapperType() : null;
                        if (sourceWrapperType != null && this.matches(sourceOp.getWrapper(), targetOp.getWrapper())) {
                            sourceWrapperType.getPhysical();
                            Object sourceWrapper2 = sourceWrapperHandler.create(sourceOp, false);
                            if (sourceWrapper2 != null) {
                                if (childElements.isEmpty()) return this.mediator.mediate(sourceWrapper2, sourceWrapperType, (DataType)targetType.getLogical(), context.getMetadata());
                                sourceWrapperHandler.setChildren(sourceWrapper2, new Object[]{response}, sourceOp, false);
                                return this.mediator.mediate(sourceWrapper2, sourceWrapperType, (DataType)targetType.getLogical(), context.getMetadata());
                            }
                        }
                    }
                    Object targetWrapper = targetWrapperHandler.create(targetOp, false);
                    if (childElements.isEmpty()) {
                        return targetWrapper;
                    }
                    DataType argType = wrapper.getUnwrappedOutputType();
                    Object child = response;
                    child = this.mediator.mediate(response, (DataType)sourceType.getLogical(), argType, context.getMetadata());
                    targetWrapperHandler.setChildren(targetWrapper, new Object[]{child}, targetOp, false);
                    return targetWrapper;
                }
                if (!sourceWrapped) return this.mediator.mediate(response, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                if (targetWrapped) return this.mediator.mediate(response, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                if (targetBare) return this.mediator.mediate(response, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                sourceWrapper = response;
                List childElements = sourceOp.getWrapper().getOutputChildElements();
                if (!childElements.isEmpty()) break block12;
                return null;
            }
            catch (Exception e) {
                throw new TransformationException((Throwable)e);
            }
        }
        if (targetWrapperHandler != null) {
            sourceOp.getWrapper().getOutputWrapperElement();
            if (sourceWrapperHandler.isInstance(sourceWrapper, sourceOp, false)) {
                DataType targetWrapperType;
                WrapperInfo targetWrapperInfo = targetOp.getWrapper();
                DataType dataType = targetWrapperType = targetWrapperInfo != null ? targetWrapperInfo.getOutputWrapperType() : null;
                if (targetWrapperType != null && this.matches(sourceOp.getWrapper(), targetOp.getWrapper())) {
                    Object targetWrapper = this.mediator.mediate(sourceWrapper, (DataType)sourceType.getLogical(), targetWrapperType, context.getMetadata());
                    return targetWrapperHandler.getChildren(targetWrapper, targetOp, false).get(0);
                }
            }
        }
        Object child = sourceWrapperHandler.getChildren(sourceWrapper, sourceOp, false).get(0);
        DataType childType = sourceOp.getWrapper().getUnwrappedOutputType();
        return this.mediator.mediate(child, childType, (DataType)targetType.getLogical(), context.getMetadata());
    }
}

