/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Input2InputTransformer
extends BaseTransformer<Object[], Object[]>
implements PullTransformer<Object[], Object[]> {
    protected Mediator mediator;

    public Input2InputTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return "idl:input";
    }

    public String getTargetDataBinding() {
        return "idl:input";
    }

    protected Class<Object[]> getSourceType() {
        return Object[].class;
    }

    protected Class<Object[]> getTargetType() {
        return Object[].class;
    }

    public int getWeight() {
        return 10000;
    }

    private boolean matches(WrapperInfo w1, WrapperInfo w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        if (!w1.getInputWrapperElement().equals((Object)w2.getInputWrapperElement())) {
            return false;
        }
        List list1 = w1.getInputChildElements();
        List list2 = w2.getInputChildElements();
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            String n2;
            String n1 = ((ElementInfo)list1.get(i)).getQName().getLocalPart();
            if (!n1.equals(n2 = ((ElementInfo)list2.get(i)).getQName().getLocalPart())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object[] transform(Object[] source, TransformationContext context) {
        DataType sourceType = context.getSourceDataType();
        Operation sourceOp = context.getSourceOperation();
        boolean sourceWrapped = sourceOp != null && sourceOp.isWrapperStyle() && sourceOp.getWrapper() != null;
        boolean sourceBare = sourceOp != null && !sourceOp.isWrapperStyle() && sourceOp.getWrapper() == null;
        WrapperHandler sourceWrapperHandler = null;
        String sourceDataBinding = this.getDataBinding(sourceOp);
        sourceWrapperHandler = this.getWrapperHandler(sourceDataBinding, sourceWrapped);
        DataType targetType = context.getTargetDataType();
        Operation targetOp = context.getTargetOperation();
        boolean targetWrapped = targetOp != null && targetOp.isWrapperStyle() && targetOp.getWrapper() != null;
        boolean targetBare = targetOp != null && !targetOp.isWrapperStyle() && targetOp.getWrapper() == null;
        WrapperHandler targetWrapperHandler = null;
        String targetDataBinding = this.getDataBinding(targetOp);
        targetWrapperHandler = this.getWrapperHandler(targetDataBinding, targetWrapped);
        if (!sourceWrapped && !sourceBare && targetWrapped) {
            WrapperInfo wrapper = targetOp.getWrapper();
            if (source == null) {
                Object targetWrapper = targetWrapperHandler.create(targetOp, true);
                return new Object[]{targetWrapper};
            }
            if (sourceWrapperHandler != null) {
                DataType sourceWrapperType;
                WrapperInfo sourceWrapperInfo = sourceOp.getWrapper();
                DataType dataType = sourceWrapperType = sourceWrapperInfo != null ? sourceWrapperInfo.getInputWrapperType() : null;
                if (sourceWrapperType != null && this.matches(sourceOp.getWrapper(), targetOp.getWrapper())) {
                    sourceWrapperType.getPhysical();
                    Object sourceWrapper = sourceWrapperHandler.create(sourceOp, true);
                    if (sourceWrapper != null) {
                        sourceWrapperHandler.setChildren(sourceWrapper, source, sourceOp, true);
                        Object targetWrapper = this.mediator.mediate(sourceWrapper, sourceWrapperType, (DataType)((List)targetType.getLogical()).get(0), context.getMetadata());
                        return new Object[]{targetWrapper};
                    }
                }
            }
            Object targetWrapper = targetWrapperHandler.create(targetOp, true);
            List argTypes = (List)wrapper.getUnwrappedInputType().getLogical();
            Object[] targetChildren = new Object[source.length];
            int i = 0;
            while (i < source.length) {
                DataType argType = (DataType)argTypes.get(i);
                targetChildren[i] = this.mediator.mediate(source[i], (DataType)((List)sourceType.getLogical()).get(i), argType, context.getMetadata());
                ++i;
            }
            targetWrapperHandler.setChildren(targetWrapper, targetChildren, targetOp, true);
            return new Object[]{targetWrapper};
        }
        if (sourceWrapped && !targetWrapped && !targetBare) {
            Object sourceWrapper = source[0];
            Object[] target = null;
            if (targetWrapperHandler != null && sourceWrapperHandler.isInstance(sourceWrapper, sourceOp, true)) {
                DataType targetWrapperType;
                WrapperInfo targetWrapperInfo = targetOp.getWrapper();
                DataType dataType = targetWrapperType = targetWrapperInfo != null ? targetWrapperInfo.getInputWrapperType() : null;
                if (targetWrapperType != null && this.matches(sourceOp.getWrapper(), targetOp.getWrapper())) {
                    Object targetWrapper = this.mediator.mediate(sourceWrapper, (DataType)((List)sourceType.getLogical()).get(0), targetWrapperType, context.getMetadata());
                    target = targetWrapperHandler.getChildren(targetWrapper, targetOp, true).toArray();
                    return target;
                }
            }
            Object[] sourceChildren = sourceWrapperHandler.getChildren(sourceWrapper, sourceOp, true).toArray();
            target = new Object[sourceChildren.length];
            int i = 0;
            while (i < sourceChildren.length) {
                DataType childType = (DataType)((List)sourceOp.getWrapper().getUnwrappedInputType().getLogical()).get(i);
                target[i] = this.mediator.mediate(sourceChildren[i], childType, (DataType)((List)targetType.getLogical()).get(i), context.getMetadata());
                ++i;
            }
            return target;
        }
        Object[] newArgs = new Object[source.length];
        int i = 0;
        while (i < source.length) {
            Object child;
            newArgs[i] = child = this.mediator.mediate(source[i], (DataType)((List)sourceType.getLogical()).get(i), (DataType)((List)targetType.getLogical()).get(i), context.getMetadata());
            ++i;
        }
        return newArgs;
    }

    private WrapperHandler getWrapperHandler(String dataBindingId, boolean required) {
        WrapperHandler wrapperHandler = null;
        if (dataBindingId != null) {
            DataBinding dataBinding = this.mediator.getDataBindings().getDataBinding(dataBindingId);
            WrapperHandler wrapperHandler2 = wrapperHandler = dataBinding == null ? null : dataBinding.getWrapperHandler();
        }
        if (wrapperHandler == null && required) {
            throw new TransformationException("No wrapper handler is provided for databinding: " + dataBindingId);
        }
        return wrapperHandler;
    }

    private String getDataBinding(Operation operation) {
        WrapperInfo wrapper = operation.getWrapper();
        if (wrapper != null) {
            return wrapper.getDataBinding();
        }
        return null;
    }
}

