/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exception2ExceptionTransformer
extends BaseTransformer<Throwable, Throwable>
implements PullTransformer<Throwable, Throwable> {
    protected Mediator mediator;
    protected FaultExceptionMapper faultExceptionMapper;

    public Exception2ExceptionTransformer(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilityExtensionPoint = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.mediator = (Mediator)utilityExtensionPoint.getUtility(Mediator.class);
        this.faultExceptionMapper = (FaultExceptionMapper)utilityExtensionPoint.getUtility(FaultExceptionMapper.class);
    }

    protected Exception2ExceptionTransformer(Mediator mediator, FaultExceptionMapper faultExceptionMapper) {
        this.mediator = mediator;
        this.faultExceptionMapper = faultExceptionMapper;
    }

    public String getSourceDataBinding() {
        return "idl:fault";
    }

    public String getTargetDataBinding() {
        return "idl:fault";
    }

    protected Class<Throwable> getSourceType() {
        return Throwable.class;
    }

    protected Class<Throwable> getTargetType() {
        return Throwable.class;
    }

    public int getWeight() {
        return 10000;
    }

    public Throwable transform(Throwable source, TransformationContext context) {
        DataType sourceType = context.getSourceDataType();
        DataType targetType = context.getTargetDataType();
        Object sourceFaultInfo = this.faultExceptionMapper.getFaultInfo(source, ((DataType)sourceType.getLogical()).getPhysical(), context.getSourceOperation());
        Object targetFaultInfo = this.mediator.mediate(sourceFaultInfo, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
        Throwable targetException = this.faultExceptionMapper.wrapFaultInfo(targetType, source.getMessage(), targetFaultInfo, source.getCause(), context.getTargetOperation());
        return targetException == null ? source : targetException;
    }

    public void setFaultExceptionMapper(FaultExceptionMapper faultExceptionMapper) {
        this.faultExceptionMapper = faultExceptionMapper;
    }
}

