/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassByValueInterceptor
implements Interceptor {
    private DataBindingExtensionPoint dataBindings;
    private FaultExceptionMapper faultExceptionMapper;
    private DataBinding[] inputDataBindings;
    private DataBinding outputDataBinding;
    private DataBinding javaBeanDataBinding;
    private DataBinding jaxbDataBinding;
    private Operation operation;
    private Invoker nextInvoker;
    private InvocationChain chain;

    public PassByValueInterceptor(DataBindingExtensionPoint dataBindings, FaultExceptionMapper faultExceptionMapper, InvocationChain chain, Operation operation) {
        this.chain = chain;
        this.operation = operation;
        this.dataBindings = dataBindings;
        this.faultExceptionMapper = faultExceptionMapper;
        this.jaxbDataBinding = dataBindings.getDataBinding(JAXBDataBinding.NAME);
        this.javaBeanDataBinding = dataBindings.getDataBinding("java:complexType");
        if (operation.getInputType() != null) {
            List inputTypes = (List)operation.getInputType().getLogical();
            this.inputDataBindings = new DataBinding[inputTypes.size()];
            int i = 0;
            for (DataType inputType : inputTypes) {
                String id = inputType.getDataBinding();
                this.inputDataBindings[i++] = dataBindings.getDataBinding(id);
            }
        }
        if (operation.getOutputType() != null) {
            String id = operation.getOutputType().getDataBinding();
            this.outputDataBinding = dataBindings.getDataBinding(id);
        }
    }

    public Message invoke(Message msg) {
        if (this.chain.allowsPassByReference()) {
            return this.nextInvoker.invoke(msg);
        }
        msg.setBody((Object)this.copy((Object[])msg.getBody(), this.inputDataBindings, (List)this.operation.getInputType().getLogical()));
        Message resultMsg = this.nextInvoker.invoke(msg);
        if (!msg.isFault() && this.operation.getOutputType() != null) {
            resultMsg.setBody(this.copy(resultMsg.getBody(), this.outputDataBinding, this.operation.getOutputType()));
        }
        if (msg.isFault()) {
            msg.setFaultBody(this.copyFault(msg.getBody()));
        }
        return resultMsg;
    }

    private Object copyFault(Object fault) {
        if (this.faultExceptionMapper == null) {
            return fault;
        }
        for (DataType et : this.operation.getFaultTypes()) {
            if (!et.getPhysical().isInstance(fault)) continue;
            Throwable ex = (Throwable)fault;
            DataTypeImpl exType = new DataTypeImpl(ex.getClass(), (Object)new DataTypeImpl(ex.getClass(), (Object)XMLType.UNKNOWN));
            this.faultExceptionMapper.introspectFaultDataType((DataType)exType, this.operation, false);
            DataType faultType = (DataType)exType.getLogical();
            Object faultInfo = this.faultExceptionMapper.getFaultInfo(ex, faultType.getPhysical(), this.operation);
            faultInfo = this.copy(faultInfo, this.dataBindings.getDataBinding(faultType.getDataBinding()), faultType);
            fault = this.faultExceptionMapper.wrapFaultInfo((DataType)exType, ex.getMessage(), faultInfo, ex.getCause(), this.operation);
            return fault;
        }
        return fault;
    }

    private Object[] copy(Object[] data, DataBinding[] dataBindings, List<DataType> dataTypes) {
        if (data == null) {
            return null;
        }
        Object[] copy = new Object[data.length];
        IdentityHashMap map = new IdentityHashMap();
        for (int i = 0; i < data.length; ++i) {
            Object arg = data[i];
            if (arg == null) {
                copy[i] = null;
                continue;
            }
            Object copiedArg = map.get(arg);
            if (copiedArg != null) {
                copy[i] = copiedArg;
                continue;
            }
            copiedArg = this.copy(arg, dataBindings[i], dataTypes.get(i));
            map.put(arg, copiedArg);
            copy[i] = copiedArg;
        }
        return copy;
    }

    private Object copy(Object data, DataBinding dataBinding, DataType dataType) {
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        if (String.class == clazz || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || URI.class == clazz || UUID.class == clazz || QName.class == clazz) {
            return data;
        }
        if (dataBinding == null) {
            String db;
            dataType = this.dataBindings.introspectType(data, this.operation);
            if (dataType != null && (dataBinding = this.dataBindings.getDataBinding(db = dataType.getDataBinding())) == null && db != null) {
                return data;
            }
            if (dataBinding == null) {
                dataBinding = this.javaBeanDataBinding;
            }
        }
        if (dataBinding == this.javaBeanDataBinding) {
            clazz = data.getClass();
            if (clazz.isArray()) {
                Object element;
                if (Array.getLength(data) != 0 && (element = Array.get(data, 0)) != null && !(element instanceof Serializable)) {
                    dataBinding = this.jaxbDataBinding;
                }
            } else {
                if (!(data instanceof Serializable)) {
                    dataBinding = this.jaxbDataBinding;
                }
                if (data instanceof Cloneable) {
                    try {
                        Method clone = data.getClass().getMethod("clone", null);
                        try {
                            return clone.invoke(data, (Object[])null);
                        }
                        catch (InvocationTargetException e) {
                            if (!(e.getTargetException() instanceof CloneNotSupportedException)) {
                                throw new ServiceRuntimeException((Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            throw new ServiceRuntimeException((Throwable)e);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
            }
        }
        Object copy = dataBinding.copy(data, dataType, this.operation);
        return copy;
    }

    public Invoker getNext() {
        return this.nextInvoker;
    }

    public void setNext(Invoker next) {
        this.nextInvoker = next;
    }
}

