/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.context.ServiceReferenceImpl;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.osoa.sca.CallableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamReader2CallableReference
extends BaseTransformer<XMLStreamReader, CallableReference>
implements PullTransformer<XMLStreamReader, CallableReference> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final String COMPOSITE = "composite";
    public static final QName COMPOSITE_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "composite");

    public CallableReference transform(XMLStreamReader source, TransformationContext context) {
        try {
            if (source != null) {
                Class<CallableReferenceImpl> implType;
                this.skipTopLevelElement(source);
                Class refType = context.getTargetDataType().getPhysical();
                if (refType.isAssignableFrom(CallableReferenceImpl.class)) {
                    implType = CallableReferenceImpl.class;
                } else if (refType.isAssignableFrom(ServiceReferenceImpl.class)) {
                    implType = ServiceReferenceImpl.class;
                } else {
                    throw new TransformationException("Unrecognized transformation target type");
                }
                Constructor constructor = implType.getConstructor(XMLStreamReader.class);
                return (CallableReference)constructor.newInstance(source);
            }
            return null;
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    private void skipTopLevelElement(XMLStreamReader source) throws XMLStreamException {
        while (source.hasNext()) {
            QName name;
            int event = source.getEventType();
            if (event == 1 && COMPOSITE_QNAME.equals(name = source.getName())) {
                return;
            }
            source.next();
        }
        throw new TransformationException("<composite> element not found");
    }

    protected Class<XMLStreamReader> getSourceType() {
        return XMLStreamReader.class;
    }

    protected Class<CallableReference> getTargetType() {
        return CallableReference.class;
    }

    public int getWeight() {
        return 10;
    }
}

