/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.annotation.DataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private static final String JAXB_DATABINDING = "javax.xml.bind.JAXBElement";
    private DataBindingExtensionPoint dataBindingRegistry;

    public DataBindingJavaInterfaceProcessor(DataBindingExtensionPoint dataBindingRegistry) {
        this.dataBindingRegistry = dataBindingRegistry;
    }

    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (!javaInterface.isRemotable()) {
            return;
        }
        List operations = javaInterface.getOperations();
        this.processInterface(javaInterface, operations);
    }

    private void processInterface(JavaInterface javaInterface, List<Operation> operations) {
        Class clazz = javaInterface.getJavaClass();
        DataBinding dataBinding = clazz.getAnnotation(DataBinding.class);
        String dataBindingId = null;
        boolean wrapperStyle = false;
        if (dataBinding != null) {
            dataBindingId = dataBinding.value();
            wrapperStyle = dataBinding.wrapped();
        }
        HashMap<String, Operation> opMap = new HashMap<String, Operation>();
        for (Operation op : javaInterface.getOperations()) {
            opMap.put(op.getName(), op);
            if (op instanceof JavaOperation) {
                opMap.put(((JavaOperation)op).getJavaMethod().getName(), op);
            }
            if (dataBindingId == null) continue;
            op.setDataBinding(dataBindingId);
            op.setWrapperStyle(wrapperStyle);
        }
        for (Method method : clazz.getMethods()) {
            WrapperHandler handler;
            Operation operation;
            if (method.getDeclaringClass() == Object.class || (operation = (Operation)opMap.get(method.getName())) == null) continue;
            DataBinding methodDataBinding = clazz.getAnnotation(DataBinding.class);
            if (methodDataBinding == null) {
                methodDataBinding = dataBinding;
            }
            dataBindingId = null;
            wrapperStyle = false;
            if (dataBinding != null) {
                dataBindingId = dataBinding.value();
                wrapperStyle = dataBinding.wrapped();
                operation.setDataBinding(dataBindingId);
                operation.setWrapperStyle(wrapperStyle);
            }
            int i = 0;
            for (DataType d : (List)operation.getInputType().getLogical()) {
                if (d.getDataBinding() == null) {
                    d.setDataBinding(dataBindingId);
                }
                for (Annotation a : method.getParameterAnnotations()[i]) {
                    if (a.annotationType() != org.apache.tuscany.sca.databinding.annotation.DataType.class) continue;
                    String value = ((org.apache.tuscany.sca.databinding.annotation.DataType)a).value();
                    d.setDataBinding(value);
                }
                this.dataBindingRegistry.introspectType(d, operation);
                ++i;
            }
            if (operation.getOutputType() != null) {
                org.apache.tuscany.sca.databinding.annotation.DataType dt;
                DataType d = operation.getOutputType();
                if (d.getDataBinding() == null) {
                    d.setDataBinding(dataBindingId);
                }
                if ((dt = method.getAnnotation(org.apache.tuscany.sca.databinding.annotation.DataType.class)) != null) {
                    d.setDataBinding(dt.value());
                }
                this.dataBindingRegistry.introspectType(d, operation);
            }
            for (DataType d : operation.getFaultTypes()) {
                if (d.getDataBinding() == null) {
                    d.setDataBinding(dataBindingId);
                }
                this.dataBindingRegistry.introspectType(d, operation);
            }
            String db = operation.getDataBinding();
            if (db == null || JAXB_DATABINDING.equals(db)) {
                this.assignOperationDataBinding(operation);
                db = operation.getDataBinding();
            }
            if (operation.getWrapper() == null) continue;
            org.apache.tuscany.sca.databinding.DataBinding dbObj = this.dataBindingRegistry.getDataBinding(db);
            WrapperHandler wrapperHandler = handler = dbObj == null ? null : dbObj.getWrapperHandler();
            if (handler != null) {
                WrapperInfo wrapper = operation.getWrapper();
                wrapper.setInputWrapperType(handler.getWrapperType(operation, true));
                wrapper.setOutputWrapperType(handler.getWrapperType(operation, false));
            }
            if (dbObj == null || handler != null) continue;
            WrapperInfo wrapper = operation.getWrapper();
            wrapper.setInputWrapperType(null);
            wrapper.setOutputWrapperType(null);
        }
    }

    private void assignOperationDataBinding(Operation operation) {
        HashSet<String> dbs = new HashSet<String>();
        LinkedList<Object> opDataTypes = new LinkedList<Object>();
        opDataTypes.addAll((Collection)operation.getInputType().getLogical());
        opDataTypes.add(operation.getOutputType());
        for (DataType dataType : operation.getFaultTypes()) {
            opDataTypes.add(dataType.getLogical());
        }
        for (DataType dataType : opDataTypes) {
            if (dataType == null) continue;
            String dataBinding = dataType.getDataBinding();
            if ("java:array".equals(dataBinding)) {
                dataBinding = ((DataType)dataType.getLogical()).getDataBinding();
            }
            if (dataBinding == null) continue;
            dbs.add(dataBinding);
        }
        dbs.remove("java:complexType");
        dbs.remove("java:simpleType");
        if (dbs.size() == 1) {
            operation.setDataBinding((String)dbs.iterator().next());
        }
    }
}

