/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope;

import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.scope.AbstractScopeContainer;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetInitializationException;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessScopeContainer<KEY>
extends AbstractScopeContainer<KEY> {
    public StatelessScopeContainer(RuntimeComponent component) {
        super(Scope.STATELESS, component);
    }

    @Override
    public InstanceWrapper getWrapper(KEY contextId) throws TargetResolutionException {
        InstanceWrapper ctx = this.createInstanceWrapper();
        try {
            ctx.start();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            try {
                ctx.stop();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e2) {
                // empty catch block
            }
            throw new TargetInitializationException(e);
        }
        return ctx;
    }

    @Override
    public InstanceWrapper getAssociatedWrapper(KEY contextId) throws TargetResolutionException {
        return this.getWrapper(contextId);
    }

    @Override
    public void returnWrapper(InstanceWrapper wrapper, KEY contextId) throws TargetDestructionException {
        wrapper.stop();
    }
}

