/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.event.RequestEnd;
import org.apache.tuscany.sca.core.scope.AbstractScopeContainer;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.TargetInitializationException;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.event.Event;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestScopeContainer
extends AbstractScopeContainer<Thread> {
    private final Map<Thread, InstanceWrapper> contexts = new ConcurrentHashMap<Thread, InstanceWrapper>();

    public RequestScopeContainer(RuntimeComponent component) {
        super(Scope.REQUEST, component);
    }

    @Override
    public void onEvent(Event event) {
        this.checkInit();
        if (event instanceof RequestEnd) {
            // empty if block
        }
    }

    @Override
    public synchronized void start() {
        if (this.lifecycleState != 0 && this.lifecycleState != 6) {
            throw new IllegalStateException("Scope must be in UNINITIALIZED or STOPPED state [" + this.lifecycleState + "]");
        }
        this.lifecycleState = 4;
    }

    @Override
    public synchronized void stop() {
        this.contexts.clear();
        for (InstanceWrapper ctx : this.wrappers.values()) {
            try {
                ctx.stop();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
            }
        }
        this.lifecycleState = 6;
    }

    protected InstanceWrapper getInstanceWrapper(boolean create) throws TargetResolutionException {
        InstanceWrapper ctx = (InstanceWrapper)this.wrappers.get(Thread.currentThread());
        if (ctx == null && !create) {
            return null;
        }
        if (ctx == null) {
            ctx = super.createInstanceWrapper();
            try {
                ctx.start();
                this.wrappers.put(Thread.currentThread(), ctx);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                try {
                    ctx.stop();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                throw new TargetInitializationException(e);
            }
        }
        return ctx;
    }

    @Override
    public InstanceWrapper getWrapper(Thread contextId) throws TargetResolutionException {
        return this.getInstanceWrapper(true);
    }
}

