/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.conversation.ConversationListener;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.conversation.ExtendedConversation;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.core.scope.AbstractScopeContainer;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationalScopeContainer
extends AbstractScopeContainer<Object>
implements ConversationListener {
    private ConversationManager conversationManager;
    private Map<Object, InstanceLifeCycleWrapper> instanceLifecycleCollection = new ConcurrentHashMap<Object, InstanceLifeCycleWrapper>();

    public ConversationalScopeContainer(Store aStore, RuntimeComponent component) {
        super(Scope.CONVERSATION, component);
    }

    protected InstanceWrapper getInstanceWrapper(boolean create, Object contextId) throws TargetResolutionException {
        InstanceLifeCycleWrapper anInstanceWrapper;
        if (contextId == null) {
            contextId = UUID.randomUUID().toString();
            Message msgContext = ThreadMessageContext.getMessageContext();
            if (msgContext != null) {
                msgContext.getFrom().getReferenceParameters().setConversationID(contextId);
            }
        }
        if ((anInstanceWrapper = this.instanceLifecycleCollection.get(contextId)) == null && !create) {
            return null;
        }
        if (anInstanceWrapper == null) {
            anInstanceWrapper = new InstanceLifeCycleWrapper(contextId);
            this.instanceLifecycleCollection.put(contextId, anInstanceWrapper);
        }
        return anInstanceWrapper.getInstanceWrapper(contextId);
    }

    @Override
    public InstanceWrapper getWrapper(Object contextId) throws TargetResolutionException {
        return this.getInstanceWrapper(true, contextId);
    }

    @Override
    public void addWrapperReference(Object existingContextId, Object contextId) throws TargetResolutionException {
        InstanceLifeCycleWrapper existingInstanceWrapper = this.instanceLifecycleCollection.get(existingContextId);
        InstanceLifeCycleWrapper newInstanceWrapper = this.instanceLifecycleCollection.get(contextId);
        if (newInstanceWrapper == null) {
            existingInstanceWrapper.addCallbackConversation(contextId);
            this.instanceLifecycleCollection.put(contextId, existingInstanceWrapper);
        }
    }

    @Override
    public void registerWrapper(InstanceWrapper wrapper, Object contextId) throws TargetResolutionException {
        InstanceLifeCycleWrapper anInstanceWrapper = this.instanceLifecycleCollection.get(contextId);
        if (anInstanceWrapper != null) {
            if (anInstanceWrapper.getInstanceWrapper(contextId).getInstance() != wrapper.getInstance()) {
                this.remove(contextId);
            } else {
                return;
            }
        }
        anInstanceWrapper = new InstanceLifeCycleWrapper(wrapper, contextId);
        this.instanceLifecycleCollection.put(contextId, anInstanceWrapper);
    }

    @Override
    public void remove(Object contextId) throws TargetDestructionException {
        if (contextId != null && this.instanceLifecycleCollection.containsKey(contextId)) {
            InstanceLifeCycleWrapper anInstanceLifeCycleWrapper = this.instanceLifecycleCollection.get(contextId);
            this.instanceLifecycleCollection.remove(contextId);
            anInstanceLifeCycleWrapper.removeInstanceWrapper(contextId);
        }
    }

    @Override
    public void conversationEnded(ExtendedConversation conversation) {
        try {
            this.remove(conversation.getConversationID());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void conversationExpired(ExtendedConversation conversation) {
        Object conversationId = conversation.getConversationID();
        InstanceLifeCycleWrapper ilcw = this.instanceLifecycleCollection.get(conversationId);
        if (ilcw != null) {
            for (Object conversationID : ilcw.callbackConversations) {
                try {
                    ilcw.removeInstanceWrapper(conversationID);
                    this.remove(conversationID);
                }
                catch (TargetDestructionException tde) {
                    System.out.println("Could not remove conversation id " + conversationID);
                }
            }
            if (ilcw.clientConversationId != null) {
                try {
                    ilcw.removeInstanceWrapper(ilcw.clientConversationId);
                    this.remove(ilcw.clientConversationId);
                }
                catch (TargetDestructionException tde) {
                    System.out.println("Could not remove conversation id " + ilcw.clientConversationId);
                }
            }
        }
    }

    @Override
    public void conversationStarted(ExtendedConversation conversation) {
        this.startContext(conversation.getConversationID());
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    private class InstanceLifeCycleWrapper {
        private Object clientConversationId;
        private List<Object> callbackConversations = new ArrayList<Object>();

        private InstanceLifeCycleWrapper(Object contextId) throws TargetResolutionException {
            this.clientConversationId = contextId;
            this.createInstance(contextId);
        }

        private InstanceLifeCycleWrapper(InstanceWrapper wrapper, Object contextId) throws TargetResolutionException {
            this.clientConversationId = contextId;
            ConversationalScopeContainer.this.wrappers.put(contextId, wrapper);
        }

        private void addCallbackConversation(Object conversationID) {
            InstanceWrapper ctx = this.getInstanceWrapper(this.clientConversationId);
            this.callbackConversations.add(conversationID);
            ConversationalScopeContainer.this.wrappers.put(conversationID, ctx);
        }

        private InstanceWrapper getInstanceWrapper(Object contextId) {
            InstanceWrapper ctx = (InstanceWrapper)ConversationalScopeContainer.this.wrappers.get(contextId);
            return ctx;
        }

        private void removeInstanceWrapper(Object contextId) throws TargetDestructionException {
            InstanceWrapper ctx = this.getInstanceWrapper(contextId);
            ConversationalScopeContainer.this.wrappers.remove(contextId);
            if (this.clientConversationId != null && this.clientConversationId.equals(contextId)) {
                this.clientConversationId = null;
            } else {
                this.callbackConversations.remove(contextId);
            }
            if (this.clientConversationId == null && this.callbackConversations.isEmpty()) {
                ctx.stop();
            }
        }

        private void createInstance(Object contextId) throws TargetResolutionException {
            InstanceWrapper instanceWrapper = ConversationalScopeContainer.this.createInstanceWrapper();
            instanceWrapper.start();
            ConversationalScopeContainer.this.wrappers.put(contextId, instanceWrapper);
        }
    }
}

