/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.InvocationHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.context.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceImpl;
import org.apache.tuscany.sca.core.invocation.JDKCallbackInvocationHandler;
import org.apache.tuscany.sca.core.invocation.JDKInvocationHandler;
import org.apache.tuscany.sca.core.invocation.ProxyCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.SCAProxy;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKProxyFactory
implements ProxyFactory {
    protected InterfaceContractMapper contractMapper;
    private MessageFactory messageFactory;

    public JDKProxyFactory(MessageFactory messageFactory, InterfaceContractMapper mapper) {
        this.contractMapper = mapper;
        this.messageFactory = messageFactory;
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, RuntimeWire wire) throws ProxyCreationException {
        ServiceReferenceImpl<T> serviceReference = new ServiceReferenceImpl<T>(interfaze, wire, this);
        return this.createProxy(serviceReference);
    }

    @Override
    public <T> T createProxy(CallableReference<T> callableReference) throws ProxyCreationException {
        assert (callableReference != null);
        final Class interfaze = callableReference.getBusinessInterface();
        JDKInvocationHandler handler = new JDKInvocationHandler(this.messageFactory, callableReference);
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return interfaze.getClassLoader();
            }
        });
        Object proxy = SCAProxy.newProxyInstance(cl, new Class[]{interfaze}, (InvocationHandler)handler);
        ((CallableReferenceImpl)callableReference).setProxy(proxy);
        return interfaze.cast(proxy);
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, List<RuntimeWire> wires) throws ProxyCreationException {
        CallbackReferenceImpl callbackReference = CallbackReferenceImpl.newInstance(interfaze, this, wires);
        return callbackReference != null ? (T)this.createCallbackProxy(callbackReference) : null;
    }

    @Override
    public <T> T createCallbackProxy(CallbackReferenceImpl<T> callbackReference) throws ProxyCreationException {
        assert (callbackReference != null);
        Class interfaze = callbackReference.getBusinessInterface();
        JDKCallbackInvocationHandler handler = new JDKCallbackInvocationHandler(this.messageFactory, callbackReference);
        ClassLoader cl = interfaze.getClassLoader();
        Object proxy = SCAProxy.newProxyInstance(cl, new Class[]{interfaze}, (InvocationHandler)handler);
        callbackReference.setProxy(proxy);
        return (T)interfaze.cast(proxy);
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        InvocationHandler handler = SCAProxy.getInvocationHandler(target);
        if (handler instanceof JDKInvocationHandler) {
            return (R)((JDKInvocationHandler)handler).getCallableReference();
        }
        throw new IllegalArgumentException("The object is not a known proxy.");
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        return SCAProxy.isProxyClass(clazz);
    }
}

