/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.invocation.InvocationChainImpl;
import org.apache.tuscany.sca.core.invocation.NonBlockingInterceptor;
import org.apache.tuscany.sca.core.invocation.RuntimeWireInvoker;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProviderRRB;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProviderRRB;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeWireImpl
implements RuntimeWire {
    private EndpointReference wireSource;
    private EndpointReference wireTarget;
    private transient RuntimeWireProcessor wireProcessor;
    private transient InterfaceContractMapper interfaceContractMapper;
    private transient WorkScheduler workScheduler;
    private transient MessageFactory messageFactory;
    private transient ConversationManager conversationManager;
    private transient RuntimeWireInvoker invoker;
    private EndpointReference lastCallback;
    private RuntimeWire cachedWire;
    private boolean wireReserved;
    private RuntimeWireImpl clonedFrom;
    private List<InvocationChain> chains;
    private InvocationChain bindingInvocationChain;

    public RuntimeWireImpl(EndpointReference source, EndpointReference target, InterfaceContractMapper interfaceContractMapper, WorkScheduler workScheduler, RuntimeWireProcessor wireProcessor, MessageFactory messageFactory, ConversationManager conversationManager) {
        this.wireSource = source;
        this.wireTarget = target;
        this.interfaceContractMapper = interfaceContractMapper;
        this.workScheduler = workScheduler;
        this.wireProcessor = wireProcessor;
        this.messageFactory = messageFactory;
        this.conversationManager = conversationManager;
        this.invoker = new RuntimeWireInvoker(this.messageFactory, this.conversationManager, this);
    }

    public synchronized List<InvocationChain> getInvocationChains() {
        if (this.chains == null) {
            this.initInvocationChains();
        }
        return this.chains;
    }

    public synchronized InvocationChain getBindingInvocationChain() {
        if (this.bindingInvocationChain == null) {
            Contract source = this.wireSource.getContract();
            if (source instanceof RuntimeComponentReference) {
                this.bindingInvocationChain = new InvocationChainImpl(null, null, true);
                this.initReferenceBindingInvocationChains();
            } else {
                this.bindingInvocationChain = new InvocationChainImpl(null, null, false);
                this.initServiceBindingInvocationChains();
            }
        }
        return this.bindingInvocationChain;
    }

    public InvocationChain getInvocationChain(Operation operation) {
        for (InvocationChain chain : this.getInvocationChains()) {
            Operation op = null;
            op = this.wireSource.getContract() != null ? chain.getSourceOperation() : chain.getTargetOperation();
            if (!this.interfaceContractMapper.isCompatible(operation, op, op.getInterface().isRemotable())) continue;
            return chain;
        }
        return null;
    }

    public Object invoke(Message msg) throws InvocationTargetException {
        return this.getBindingInvocationChain().getHeadInvoker().invoke(msg);
    }

    public Object invoke(Operation operation, Object[] args) throws InvocationTargetException {
        Message msg = this.messageFactory.createMessage();
        msg.setBody((Object)args);
        return this.invoker.invoke(operation, msg);
    }

    public Object invoke(Operation operation, Message msg) throws InvocationTargetException {
        return this.invoker.invoke(operation, msg);
    }

    private void initInvocationChains() {
        this.chains = new ArrayList<InvocationChain>();
        InterfaceContract sourceContract = this.wireSource.getInterfaceContract();
        InterfaceContract targetContract = this.wireTarget.getInterfaceContract();
        Contract source = this.wireSource.getContract();
        if (source instanceof RuntimeComponentReference) {
            RuntimeComponentReference reference = (RuntimeComponentReference)this.wireSource.getContract();
            Binding refBinding = this.wireSource.getBinding();
            for (Operation operation : sourceContract.getInterface().getOperations()) {
                Operation targetOperation = this.interfaceContractMapper.map(targetContract.getInterface(), operation);
                if (targetOperation == null) {
                    throw new ServiceRuntimeException("No matching operation for " + operation.getName() + " is found in reference " + this.wireSource.getComponent().getURI() + "#" + reference.getName());
                }
                InvocationChainImpl chain = new InvocationChainImpl(operation, targetOperation, true);
                if (operation.isNonBlocking()) {
                    this.addNonBlockingInterceptor((ComponentReference)reference, refBinding, (InvocationChain)chain);
                }
                this.addReferenceBindingInterceptor((ComponentReference)reference, refBinding, chain, operation);
                this.chains.add(chain);
            }
        } else {
            RuntimeComponentService service = (RuntimeComponentService)this.wireTarget.getContract();
            RuntimeComponent serviceComponent = this.wireTarget.getComponent();
            Binding serviceBinding = this.wireTarget.getBinding();
            for (Operation operation : sourceContract.getInterface().getOperations()) {
                Operation targetOperation = this.interfaceContractMapper.map(targetContract.getInterface(), operation);
                if (targetOperation == null) {
                    throw new ServiceRuntimeException("No matching operation for " + operation.getName() + " is found in service " + serviceComponent.getURI() + "#" + service.getName());
                }
                InvocationChainImpl chain = new InvocationChainImpl(operation, targetOperation, false);
                if (operation.isNonBlocking()) {
                    this.addNonBlockingInterceptor((ComponentService)service, serviceBinding, (InvocationChain)chain);
                }
                this.addServiceBindingInterceptor((ComponentService)service, serviceBinding, chain, operation);
                this.addImplementationInterceptor((Component)serviceComponent, (ComponentService)service, chain, targetOperation);
                this.chains.add(chain);
            }
        }
        this.wireProcessor.process((RuntimeWire)this);
    }

    private void initReferenceBindingInvocationChains() {
        List pps;
        Binding referenceBinding;
        RuntimeComponentReference reference = (RuntimeComponentReference)this.wireSource.getContract();
        ReferenceBindingProvider provider = reference.getBindingProvider(referenceBinding = this.wireSource.getBinding());
        if (provider != null && provider instanceof ReferenceBindingProviderRRB) {
            ((ReferenceBindingProviderRRB)provider).configureBindingChain((RuntimeWire)this);
        }
        if ((pps = reference.getPolicyProviders(referenceBinding)) != null) {
            for (PolicyProvider p : pps) {
                Interceptor interceptor;
                if (!p.getPhase().equals("reference.binding.policy") || (interceptor = p.createInterceptor(null)) == null) continue;
                this.bindingInvocationChain.addInterceptor("reference.binding.policy", interceptor);
            }
        }
    }

    private void initServiceBindingInvocationChains() {
        List pps;
        Binding serviceBinding;
        RuntimeComponentService service = (RuntimeComponentService)this.wireTarget.getContract();
        ServiceBindingProvider provider = service.getBindingProvider(serviceBinding = this.wireTarget.getBinding());
        if (provider != null && provider instanceof ServiceBindingProviderRRB) {
            ((ServiceBindingProviderRRB)provider).configureBindingChain((RuntimeWire)this);
        }
        if ((pps = service.getPolicyProviders(serviceBinding)) != null) {
            for (PolicyProvider p : pps) {
                Interceptor interceptor;
                if (!p.getPhase().equals("service.binding.policy") || (interceptor = p.createInterceptor(null)) == null) continue;
                this.bindingInvocationChain.addInterceptor("service.binding.policy", interceptor);
            }
        }
        this.bindingInvocationChain.addInvoker((Invoker)this.invoker);
    }

    public EndpointReference getSource() {
        return this.wireSource;
    }

    public EndpointReference getTarget() {
        return this.wireTarget;
    }

    public void setTarget(EndpointReference target) {
        if (this.wireTarget != target) {
            this.rebuild();
        }
        this.wireTarget = target;
    }

    public void rebuild() {
        this.chains = null;
    }

    private void addReferenceBindingInterceptor(ComponentReference reference, Binding binding, InvocationChain chain, Operation operation) {
        List pps;
        Invoker invoker;
        ReferenceBindingProvider provider = ((RuntimeComponentReference)reference).getBindingProvider(binding);
        if (provider != null && (invoker = provider.createInvoker(operation)) != null) {
            chain.addInvoker(invoker);
        }
        if ((pps = ((RuntimeComponentReference)reference).getPolicyProviders(binding)) != null) {
            for (PolicyProvider p : pps) {
                Interceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor(p.getPhase(), p.createInterceptor(operation));
            }
        }
    }

    private void addServiceBindingInterceptor(ComponentService service, Binding binding, InvocationChain chain, Operation operation) {
        List pps = ((RuntimeComponentService)service).getPolicyProviders(binding);
        if (pps != null) {
            for (PolicyProvider p : pps) {
                Interceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor(p.getPhase(), p.createInterceptor(operation));
            }
        }
    }

    private void addNonBlockingInterceptor(ComponentReference reference, Binding binding, InvocationChain chain) {
        boolean supportsOneWayInvocation;
        ReferenceBindingProvider provider = ((RuntimeComponentReference)reference).getBindingProvider(binding);
        if (provider != null && !(supportsOneWayInvocation = provider.supportsOneWayInvocation())) {
            chain.addInterceptor("component.reference", (Interceptor)new NonBlockingInterceptor(this.workScheduler));
        }
    }

    private void addNonBlockingInterceptor(ComponentService service, Binding binding, InvocationChain chain) {
        ServiceBindingProvider provider = ((RuntimeComponentService)service).getBindingProvider(binding);
        if (provider != null && !provider.supportsOneWayInvocation()) {
            chain.addInterceptor("component.service", (Interceptor)new NonBlockingInterceptor(this.workScheduler));
        }
    }

    private void addImplementationInterceptor(Component component, ComponentService service, InvocationChain chain, Operation operation) {
        List pps;
        ImplementationProvider provider = ((RuntimeComponent)component).getImplementationProvider();
        if (provider != null) {
            Invoker invoker = null;
            invoker = provider.createInvoker((RuntimeComponentService)service, operation);
            chain.addInvoker(invoker);
        }
        if ((pps = ((RuntimeComponent)component).getPolicyProviders()) != null) {
            for (PolicyProvider p : pps) {
                Interceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor(p.getPhase(), p.createInterceptor(operation));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RuntimeWireImpl copy = (RuntimeWireImpl)super.clone();
        copy.wireSource = (EndpointReference)this.wireSource.clone();
        copy.wireTarget = (EndpointReference)this.wireTarget.clone();
        copy.invoker = new RuntimeWireInvoker(copy.messageFactory, copy.conversationManager, copy);
        copy.cachedWire = null;
        return copy;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public synchronized RuntimeWire lookupCache(EndpointReference callback) {
        if (this.lastCallback != null && callback.getURI().equals(this.lastCallback.getURI()) && !this.wireReserved) {
            this.wireReserved = true;
            return this.cachedWire;
        }
        return null;
    }

    public synchronized void addToCache(EndpointReference callback, RuntimeWire clonedWire) {
        ((RuntimeWireImpl)clonedWire).setClonedFrom(this);
        this.lastCallback = callback;
        this.cachedWire = clonedWire;
        this.wireReserved = true;
    }

    public synchronized void releaseClonedWire(RuntimeWire wire) {
        if (this.cachedWire == wire) {
            this.wireReserved = false;
        }
    }

    public synchronized void releaseWire() {
        this.clonedFrom.releaseClonedWire(this);
    }

    private void setClonedFrom(RuntimeWireImpl wire) {
        this.clonedFrom = wire;
    }
}

