/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.assembly.CompositeActivatorImpl;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.core.invocation.InvocationChainImpl;
import org.apache.tuscany.sca.endpointresolver.EndpointResolver;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointWireImpl
implements RuntimeWire {
    private Endpoint endpoint;
    private CompositeActivatorImpl compositeActivator;
    private EndpointResolver endpointResolver;
    private EndpointReference source;
    private RuntimeWire wire;
    private InvocationChain binidngInvocationChain;

    public EndpointWireImpl(Endpoint endpoint, CompositeActivator compositeActivator) {
        this.endpoint = endpoint;
        this.compositeActivator = (CompositeActivatorImpl)compositeActivator;
        Reference componentTypeRef = endpoint.getSourceComponentReference().getReference();
        InterfaceContract sourceContract = componentTypeRef == null ? endpoint.getSourceComponentReference().getInterfaceContract() : componentTypeRef.getInterfaceContract();
        sourceContract = sourceContract.makeUnidirectional(false);
        this.source = new EndpointReferenceImpl((RuntimeComponent)endpoint.getSourceComponent(), (Contract)endpoint.getSourceComponentReference(), null, sourceContract);
        RuntimeComponentReference runtimeRef = (RuntimeComponentReference)endpoint.getSourceComponentReference();
        this.endpointResolver = runtimeRef.getEndpointResolver(endpoint);
    }

    public synchronized List<InvocationChain> getInvocationChains() {
        if (this.endpoint.isUnresolved()) {
            this.endpointResolver.resolve();
            if (this.endpoint.isUnresolved()) {
                throw new ServiceUnavailableException("Unable to resolve service for component: " + this.endpoint.getSourceComponent().getName() + " reference: " + this.endpoint.getSourceComponentReference().getName() + " target: " + this.endpoint.getTargetName());
            }
        }
        if (this.wire == null) {
            RuntimeComponentReference runtimeRef = (RuntimeComponentReference)this.endpoint.getSourceComponentReference();
            runtimeRef.getBindings().add(this.endpoint.getSourceBinding());
            this.compositeActivator.addReferenceBindingProviderForEndpoint(this.endpoint);
            ReferenceBindingProvider bindingProvider = runtimeRef.getBindingProvider(this.endpoint.getSourceBinding());
            bindingProvider.start();
            this.compositeActivator.addReferenceWireForEndpoint(this.endpoint);
            this.wire = runtimeRef.getRuntimeWire(this.endpoint.getSourceBinding());
        }
        return this.wire.getInvocationChains();
    }

    public InvocationChain getInvocationChain(Operation operation) {
        if (this.wire == null) {
            return null;
        }
        return this.wire.getInvocationChain(operation);
    }

    public Object invoke(Message msg) throws InvocationTargetException {
        return null;
    }

    public Object invoke(Operation operation, Object[] args) throws InvocationTargetException {
        return null;
    }

    public Object invoke(Operation operation, Message msg) throws InvocationTargetException {
        return null;
    }

    public EndpointReference getSource() {
        return this.source;
    }

    public EndpointReference getTarget() {
        return null;
    }

    public void setTarget(EndpointReference target) {
    }

    public void rebuild() {
    }

    public synchronized InvocationChain getBindingInvocationChain() {
        if (this.binidngInvocationChain == null) {
            this.binidngInvocationChain = this.source instanceof RuntimeComponentReference ? new InvocationChainImpl(null, null, true) : new InvocationChainImpl(null, null, false);
        }
        return this.binidngInvocationChain;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Object clone() throws CloneNotSupportedException {
        EndpointWireImpl copy = (EndpointWireImpl)super.clone();
        return copy;
    }
}

