/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionMetadataDocumentProcessor
implements URLArtifactProcessor<ContributionMetadata> {
    private final StAXArtifactProcessor staxProcessor;
    private final XMLInputFactory inputFactory;
    private final Monitor monitor;

    public ContributionMetadataDocumentProcessor(XMLInputFactory inputFactory, StAXArtifactProcessor staxProcessor, Monitor monitor) {
        this.inputFactory = inputFactory;
        this.staxProcessor = staxProcessor;
        this.monitor = monitor;
    }

    public ContributionMetadataDocumentProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor, Monitor monitor) {
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(ValidatingXMLInputFactory.class);
        this.staxProcessor = staxProcessor;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public String getArtifactType() {
        return "sca-contribution.xml";
    }

    public Class<ContributionMetadata> getModelType() {
        return ContributionMetadata.class;
    }

    public ContributionMetadata read(URL contributionURL, URI uri, URL url) throws ContributionReadException {
        InputStream urlStream = null;
        try {
            ContributionMetadata contribution;
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            urlStream = connection.getInputStream();
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(urlStream);
            reader.nextTag();
            ContributionMetadata contributionMetadata = contribution = (ContributionMetadata)this.staxProcessor.read(reader);
            return contributionMetadata;
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", this.inputFactory, (Exception)ex);
            throw ex;
        }
        catch (IOException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("IOException", this.inputFactory, (Exception)ex);
            throw ex;
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                    urlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
    }

    public void resolve(ContributionMetadata contribution, ModelResolver resolver) throws ContributionResolveException {
        this.staxProcessor.resolve((Object)contribution, resolver);
    }
}

