/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyAttributeProcessor
extends BaseStAXArtifactProcessor
implements StAXAttributeProcessor<Extension> {
    private static final QName ANY_ATTRIBUTE = new QName("http://www.w3.org/2001/XMLSchema", "anyAttribute");
    private ExtensionFactory extensionFactory;

    public AnyAttributeProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.extensionFactory = (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class);
    }

    public QName getArtifactType() {
        return ANY_ATTRIBUTE;
    }

    public Class<Extension> getModelType() {
        return Extension.class;
    }

    public Extension read(QName attributeName, XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String attributeValue = reader.getAttributeValue(attributeName.getNamespaceURI(), attributeName.getLocalPart());
        return this.extensionFactory.createExtension(attributeName, (Object)attributeValue, true);
    }

    public void write(Extension attributeExtension, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeAttribute(attributeExtension.getQName().getPrefix(), attributeExtension.getQName().getNamespaceURI(), attributeExtension.getQName().getLocalPart(), attributeExtension.getValue().toString());
    }

    public void resolve(Extension arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

