/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.xml;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionMetadataProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<ContributionMetadata> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName CONTRIBUTION_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "contribution");
    private static final QName DEPLOYABLE_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "deployable");
    private final AssemblyFactory assemblyFactory;
    private final ContributionFactory contributionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private Monitor monitor;

    public ContributionMetadataProcessor(AssemblyFactory assemblyFactory, ContributionFactory contributionFactory, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.assemblyFactory = assemblyFactory;
        this.contributionFactory = contributionFactory;
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public ContributionMetadataProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    public QName getArtifactType() {
        return CONTRIBUTION_QNAME;
    }

    public Class<ContributionMetadata> getModelType() {
        return ContributionMetadata.class;
    }

    public ContributionMetadata read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ContributionMetadata contribution = null;
        QName name = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (CONTRIBUTION_QNAME.equals(name)) {
                        contribution = this.contributionFactory.createContributionMetadata();
                        contribution.setUnresolved(true);
                        break;
                    }
                    if (DEPLOYABLE_QNAME.equals(name)) {
                        QName compositeName = this.getQName(reader, "composite");
                        if (compositeName == null) {
                            this.error("AttributeCompositeMissing", reader, new Object[0]);
                            break;
                        }
                        if (contribution == null) break;
                        Composite composite = this.assemblyFactory.createComposite();
                        composite.setName(compositeName);
                        composite.setUnresolved(true);
                        contribution.getDeployables().add(composite);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension == null || contribution == null) break;
                    if (extension instanceof Import) {
                        contribution.getImports().add((Import)extension);
                        break;
                    }
                    if (!(extension instanceof Export)) break;
                    contribution.getExports().add((Export)extension);
                    break;
                }
                case 2: {
                    if (!CONTRIBUTION_QNAME.equals(reader.getName())) break;
                    return contribution;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return contribution;
    }

    public void write(ContributionMetadata contribution, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, CONTRIBUTION_QNAME.getNamespaceURI(), CONTRIBUTION_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        for (Import imp : contribution.getImports()) {
            this.extensionProcessor.write((Object)imp, writer);
        }
        for (Export export : contribution.getExports()) {
            this.extensionProcessor.write((Object)export, writer);
        }
        for (Composite deployable : contribution.getDeployables()) {
            this.writeStart(writer, DEPLOYABLE_QNAME.getNamespaceURI(), DEPLOYABLE_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("composite", deployable.getName())});
            this.writeEnd(writer);
        }
        this.writeEndDocument(writer);
    }

    public void resolve(ContributionMetadata contribution, ModelResolver resolver) throws ContributionResolveException {
        for (Export export : contribution.getExports()) {
            this.extensionProcessor.resolve((Object)export, resolver);
        }
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve((Object)import_, resolver);
        }
        List deployables = contribution.getDeployables();
        int n = deployables.size();
        for (int i = 0; i < n; ++i) {
            Composite deployable = (Composite)deployables.get(i);
            Composite resolved = (Composite)resolver.resolveModel(Composite.class, (Object)deployable);
            if (resolved == deployable) continue;
            deployables.set(i, resolved);
        }
        contribution.setUnresolved(false);
    }
}

