/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyElementProcessor
implements StAXArtifactProcessor<Object> {
    private static final QName ANY_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "anyElement");
    private static final Logger logger = Logger.getLogger(AnyElementProcessor.class.getName());
    private DocumentBuilderFactory documentBuilderFactory;
    private Document document;
    private Monitor monitor;

    public AnyElementProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.documentBuilderFactory = (DocumentBuilderFactory)modelFactories.getFactory(DocumentBuilderFactory.class);
        this.monitor = monitor;
    }

    public QName getArtifactType() {
        return ANY_ELEMENT;
    }

    public Class<Object> getModelType() {
        return Object.class;
    }

    public Object read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        int event = reader.getEventType();
        int level = 0;
        ArrayList<String> elementList = new ArrayList<String>();
        this.document = this.createDocument();
        QName name = reader.getName();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    elementList.add(reader.getName().getLocalPart());
                    if (level == 0) {
                        this.generateDOM(reader, null);
                        ++level;
                        break;
                    }
                    this.generateDOM(reader, ((String)elementList.get(elementList.size() - 2)).toString());
                    break;
                }
                case 2: {
                    elementList.remove(reader.getName().getLocalPart());
                }
            }
            if (reader.hasNext()) {
                event = reader.next();
            }
            if (event != 1 && event != 2 || !reader.getName().equals(name)) continue;
            break;
        }
        return this.document;
    }

    public void write(Object model, XMLStreamWriter writer) {
        if (!(model instanceof Document)) {
            return;
        }
        Document doc = (Document)model;
        try {
            DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
            TreeWalker walker = traversal.createTreeWalker(doc.getDocumentElement(), -1, null, true);
            this.writeDOM(walker, writer);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Document not created ");
            }
            this.error("Document not created", (Object)this.document, e);
        }
    }

    public void resolve(Object arg0, ModelResolver arg1) throws ContributionResolveException {
    }

    private void generateDOM(XMLStreamReader reader, String parent) {
        try {
            String elePrefix = reader.getPrefix();
            String eleQName = reader.getLocalName();
            if (elePrefix != null && elePrefix.length() != 0) {
                eleQName = elePrefix + ":" + eleQName;
            }
            Element element = this.document.createElementNS(reader.getNamespaceURI(), eleQName);
            int attributeCount = reader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String ns = reader.getAttributeNamespace(i);
                String prefix = reader.getAttributePrefix(i);
                String qname = reader.getAttributeLocalName(i);
                String value = reader.getAttributeValue(i);
                if (prefix != null && prefix.length() != 0) {
                    qname = prefix + ":" + qname;
                }
                element.setAttributeNS(ns, qname, value);
            }
            if (parent == null) {
                if (this.document != null) {
                    this.document.appendChild(element);
                } else {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "Document not created ");
                    }
                    this.error("Document not created", (Object)this.document, element);
                }
            } else {
                Node parentNode = this.getParentNode(this.document, parent);
                if (parentNode != null) {
                    parentNode.appendChild(element);
                } else {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "Parent node not found");
                    }
                    this.error("Parent node not found", (Object)this.document, parentNode.getNodeName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Document not created ");
            }
            this.error("Document not created", (Object)this.document, e);
        }
    }

    private Document createDocument() {
        try {
            this.document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
            return this.document;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeDOM(TreeWalker walker, XMLStreamWriter writer) throws XMLStreamException {
        Node parent = walker.getCurrentNode();
        writer.writeStartElement(parent.getPrefix(), parent.getLocalName(), parent.getNamespaceURI());
        NamedNodeMap attributes = parent.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            writer.writeAttribute(attributes.item(i).getPrefix(), attributes.item(i).getNamespaceURI(), attributes.item(i).getLocalName(), attributes.item(i).getNodeValue());
        }
        Node n = walker.firstChild();
        while (n != null) {
            this.writeDOM(walker, writer);
            n = walker.nextSibling();
        }
        writer.writeEndElement();
        walker.setCurrentNode(parent);
    }

    private Node getParentNode(Node doc, String parent) {
        Node parentNode = null;
        try {
            DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
            String prefixChar = ":";
            NodeIterator iterator = traversal.createNodeIterator(this.document.getDocumentElement(), 1, null, true);
            Node n = iterator.nextNode();
            while (n != null) {
                String nodeName = n.getNodeName();
                String[] str = null;
                if (n.getNodeName().contains(prefixChar)) {
                    str = nodeName.split(":");
                    nodeName = str[str.length - 1];
                }
                if (parent.equalsIgnoreCase(nodeName)) {
                    parentNode = n;
                }
                n = iterator.nextNode();
            }
            return parentNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return parentNode;
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }
}

