/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.java.JavaImportExportFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImportProcessor
implements StAXArtifactProcessor<JavaImport> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200903";
    private static final QName IMPORT_JAVA = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "import.java");
    private static final String PACKAGE = "package";
    private static final String LOCATION = "location";
    private final JavaImportExportFactory factory;
    private final Monitor monitor;

    public JavaImportProcessor(FactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = (JavaImportExportFactory)modelFactories.getFactory(JavaImportExportFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            Problem problem = this.monitor.createProblem(this.getClass().getName(), "contribution-java-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    public QName getArtifactType() {
        return IMPORT_JAVA;
    }

    public Class<JavaImport> getModelType() {
        return JavaImport.class;
    }

    public JavaImport read(XMLStreamReader reader) throws ContributionReadException {
        JavaImport javaImport = this.factory.createJavaImport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (!IMPORT_JAVA.equals(element)) break;
                        String packageName = reader.getAttributeValue(null, PACKAGE);
                        if (packageName == null) {
                            this.error("AttributePackageMissing", reader, new Object[0]);
                        } else {
                            javaImport.setPackage(packageName);
                        }
                        String location = reader.getAttributeValue(null, LOCATION);
                        javaImport.setLocation(location);
                        break;
                    }
                    case 2: {
                        if (!IMPORT_JAVA.equals(reader.getName())) break;
                        return javaImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", reader, ex);
        }
        return javaImport;
    }

    public void write(JavaImport javaImport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPORT_JAVA.getNamespaceURI(), IMPORT_JAVA.getLocalPart());
        if (javaImport.getPackage() != null) {
            writer.writeAttribute(PACKAGE, javaImport.getPackage());
        }
        if (javaImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, javaImport.getLocation());
        }
        writer.writeEndElement();
    }

    public void resolve(JavaImport model, ModelResolver resolver) throws ContributionResolveException {
    }
}

