/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImportExportFactory;
import org.apache.tuscany.sca.contribution.java.impl.JavaExportModelResolver;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExportProcessor
implements StAXArtifactProcessor<JavaExport> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200903";
    private static final QName EXPORT_JAVA = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "export.java");
    private static final String PACKAGE = "package";
    private final JavaImportExportFactory factory;
    private final Monitor monitor;

    public JavaExportProcessor(FactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = (JavaImportExportFactory)modelFactories.getFactory(JavaImportExportFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            Problem problem = this.monitor.createProblem(this.getClass().getName(), "contribution-java-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    public QName getArtifactType() {
        return EXPORT_JAVA;
    }

    public Class<JavaExport> getModelType() {
        return JavaExport.class;
    }

    public JavaExport read(XMLStreamReader reader) throws ContributionReadException {
        JavaExport javaExport = this.factory.createJavaExport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (!EXPORT_JAVA.equals(element)) break;
                        String packageName = reader.getAttributeValue(null, PACKAGE);
                        if (packageName == null) {
                            this.error("AttributePackageMissing", reader, new Object[0]);
                            break;
                        }
                        javaExport.setPackage(packageName);
                        break;
                    }
                    case 2: {
                        if (!EXPORT_JAVA.equals(reader.getName())) break;
                        return javaExport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", reader, ex);
        }
        return javaExport;
    }

    public void write(JavaExport javaExport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(EXPORT_JAVA.getNamespaceURI(), EXPORT_JAVA.getLocalPart());
        if (javaExport.getPackage() != null) {
            writer.writeAttribute(PACKAGE, javaExport.getPackage());
        }
        writer.writeEndElement();
    }

    public void resolve(JavaExport javaExport, ModelResolver resolver) throws ContributionResolveException {
        if (javaExport.getPackage() != null) {
            javaExport.setModelResolver(new JavaExportModelResolver(javaExport, resolver));
        }
    }
}

