/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.impl.ExtensibleImpl;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImportImpl
extends ExtensibleImpl
implements JavaImport {
    private ModelResolver modelResolver;
    private List<Contribution> contributions;
    private String packageName;
    private String location;

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    public void setModelResolver(ModelResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

    public List<Contribution> getExportContributions() {
        return this.contributions;
    }

    public void setExportContributions(List<Contribution> contributions) {
        this.contributions = contributions;
    }

    public boolean match(Export export) {
        if (export instanceof JavaExport) {
            String prefix;
            JavaExport javaExport = (JavaExport)export;
            String exportedPackage = javaExport.getPackage();
            if (this.packageName.equals(exportedPackage)) {
                return true;
            }
            if (this.packageName.endsWith(".*") && exportedPackage.startsWith(prefix = this.packageName.substring(0, this.packageName.length() - 1))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.packageName);
    }
}

