/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.java.impl.JavaExportImpl;
import org.apache.tuscany.sca.contribution.java.impl.JavaImportModelResolver;
import org.apache.tuscany.sca.contribution.resolver.DefaultImportAllModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionListener;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;

public class JavaImportExportListener
implements ContributionListener {
    private ContributionFactory contributionFactory;

    public JavaImportExportListener(ModelFactoryExtensionPoint modelFactories) {
        this.contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
    }

    public void contributionAdded(ContributionRepository repository, Contribution contribution) {
        ModelResolver modelResolver = contribution.getModelResolver();
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI("META-INF/sca-contribution.xml");
        artifact = (Artifact)modelResolver.resolveModel(Artifact.class, (Object)artifact);
        if (artifact.getLocation() == null) {
            artifact.setURI("META-INF/sca-contribution-generated.xml");
            artifact = (Artifact)modelResolver.resolveModel(Artifact.class, (Object)artifact);
            if (artifact.getLocation() == null) {
                HashSet<String> packages = new HashSet<String>();
                for (Artifact a : contribution.getArtifacts()) {
                    int d;
                    String uri = a.getURI();
                    if (!uri.endsWith(".class") || (d = (uri = uri.substring(0, uri.length() - 6)).lastIndexOf(47)) == -1) continue;
                    packages.add(uri.substring(0, d).replace('/', '.'));
                }
                for (String pkg : packages) {
                    JavaExportImpl export = new JavaExportImpl();
                    export.setPackage(pkg);
                    contribution.getExports().add(export);
                }
            }
        }
        for (Export export : contribution.getExports()) {
            export.setModelResolver(contribution.getModelResolver());
        }
        for (Import import_ : contribution.getImports()) {
            Contribution targetContribution;
            boolean initialized = false;
            if (!(import_ instanceof JavaImport)) continue;
            JavaImport javaImport = (JavaImport)import_;
            if (javaImport.getLocation() != null && (targetContribution = repository.getContribution(javaImport.getLocation())) != null) {
                for (Export export : targetContribution.getExports()) {
                    if (!(export instanceof JavaExport)) continue;
                    JavaExport javaExport = (JavaExport)export;
                    if (!javaImport.getPackage().equals(javaExport.getPackage())) continue;
                    ArrayList<Contribution> exportingContributions = new ArrayList<Contribution>();
                    exportingContributions.add(targetContribution);
                    javaImport.setModelResolver(new JavaImportModelResolver(exportingContributions, javaExport.getModelResolver()));
                    initialized = true;
                    break;
                }
            }
            if (initialized) continue;
            import_.setModelResolver((ModelResolver)new JavaImportModelResolver(repository.getContributions(), (ModelResolver)new DefaultImportAllModelResolver(import_, repository.getContributions())));
        }
    }

    public void contributionRemoved(ContributionRepository repository, Contribution contribution) {
    }

    public void contributionUpdated(ContributionRepository repository, Contribution oldContribution, Contribution contribution) {
    }
}

