/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImportExportFactory;
import org.apache.tuscany.sca.contribution.java.impl.JavaExportModelResolver;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExportProcessor
implements StAXArtifactProcessor<JavaExport> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName EXPORT_JAVA = new QName("http://www.osoa.org/xmlns/sca/1.0", "export.java");
    private static final String PACKAGE = "package";
    private final JavaImportExportFactory factory;
    private final Monitor monitor;

    public JavaExportProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = (JavaImportExportFactory)modelFactories.getFactory(JavaImportExportFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-java-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-java-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public QName getArtifactType() {
        return EXPORT_JAVA;
    }

    public Class<JavaExport> getModelType() {
        return JavaExport.class;
    }

    public JavaExport read(XMLStreamReader reader) throws ContributionReadException {
        JavaExport javaExport = this.factory.createJavaExport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (!EXPORT_JAVA.equals(element)) break;
                        String packageName = reader.getAttributeValue(null, PACKAGE);
                        if (packageName == null) {
                            this.error("AttributePackageMissing", (Object)reader, new Object[0]);
                            break;
                        }
                        javaExport.setPackage(packageName);
                        break;
                    }
                    case 2: {
                        if (!EXPORT_JAVA.equals(reader.getName())) break;
                        return javaExport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", (Object)reader, (Exception)ex);
        }
        return javaExport;
    }

    public void write(JavaExport javaExport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(EXPORT_JAVA.getNamespaceURI(), EXPORT_JAVA.getLocalPart());
        if (javaExport.getPackage() != null) {
            writer.writeAttribute(PACKAGE, javaExport.getPackage());
        }
        writer.writeEndElement();
    }

    public void resolve(JavaExport javaExport, ModelResolver resolver) throws ContributionResolveException {
        if (javaExport.getPackage() != null) {
            javaExport.setModelResolver(new JavaExportModelResolver(javaExport, resolver));
        }
    }
}

