/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.scanner.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;

public class JarContributionScanner
implements ContributionScanner {
    private ContributionFactory contributionFactory;

    public JarContributionScanner(ContributionFactory contributionFactory) {
        this.contributionFactory = contributionFactory;
    }

    @Override
    public String getContributionType() {
        return "application/java-archive";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Artifact> scan(Contribution contribution) throws ContributionReadException {
        ArrayList<Artifact> arrayList;
        URL url = new URL(contribution.getLocation());
        JarInputStream jar = new JarInputStream(IOHelper.openStream((URL)url));
        try {
            JarEntry entry;
            HashSet<String> names = new HashSet<String>();
            while ((entry = jar.getNextJarEntry()) != null) {
                int s;
                String name = entry.getName();
                if (name.length() == 0 || name.startsWith(".")) continue;
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (names.contains(name)) continue;
                names.add(name);
                while ((name = (s = name.lastIndexOf(47)) == -1 ? "" : name.substring(0, s)).length() != 0 && !names.contains(name)) {
                    names.add(name);
                }
            }
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            for (String uri : names) {
                Artifact artifact = this.contributionFactory.createArtifact();
                artifact.setURI(uri);
                artifact.setLocation(JarContributionScanner.getArtifactURL(contribution, uri).toString());
                artifacts.add(artifact);
            }
            contribution.getTypes().add(this.getContributionType());
            arrayList = artifacts;
        }
        catch (Throwable throwable) {
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ContributionReadException(e);
            }
        }
        jar.close();
        return arrayList;
    }

    private static URL getArtifactURL(Contribution contribution, String artifact) throws ContributionReadException {
        try {
            URL url = contribution.toString().startsWith("jar:") ? new URL(new URL(contribution.getLocation()), artifact.toString()) : new URL("jar:" + contribution.getLocation() + "!/" + artifact);
            return url;
        }
        catch (MalformedURLException e) {
            throw new ContributionReadException(e);
        }
    }
}

