/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.net.URI;
import java.net.URL;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.UnrecognizedElementException;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ExtensibleURLArtifactProcessor
implements URLArtifactProcessor<Object> {
    private URLArtifactProcessorExtensionPoint processors;

    public ExtensibleURLArtifactProcessor(URLArtifactProcessorExtensionPoint processors) {
        this.processors = processors;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public Object read(URL contributionURL, URI sourceURI, URL sourceURL, ProcessorContext context) throws ContributionReadException {
        URLArtifactProcessor processor = null;
        if (sourceURI != null) {
            String uri = sourceURI.toString();
            if (!uri.startsWith("/")) {
                uri = "/" + uri;
            }
            processor = this.processors.getProcessor(uri);
        }
        if (processor == null) {
            return null;
        }
        if (context != null && context.getMonitor() != null) {
            context.getMonitor().setArtifactName(null);
        }
        return processor.read(contributionURL, sourceURI, sourceURL, context);
    }

    @Override
    public void resolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        URLArtifactProcessor<?> processor;
        if (model != null && (processor = this.processors.getProcessor(model.getClass())) != null) {
            processor.resolve(model, resolver, context);
        }
    }

    public <M> M read(URL contributionURL, URI artifactURI, URL artifactUrl, ProcessorContext context, Class<M> type) throws ContributionReadException {
        Object mo = this.read(contributionURL, artifactURI, artifactUrl, context);
        if (type.isInstance(mo)) {
            return type.cast(mo);
        }
        UnrecognizedElementException e = new UnrecognizedElementException(null);
        e.setResourceURI(artifactURI.toString());
        this.error(context.getMonitor(), "UnrecognizedElementException", this.processors, artifactURI.toString());
        throw e;
    }

    @Override
    public String getArtifactType() {
        return "";
    }

    @Override
    public Class<Object> getModelType() {
        return Object.class;
    }
}

