/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.processor.PackageProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.apache.tuscany.sca.contribution.service.TypeDescriber;
import org.apache.tuscany.sca.contribution.service.UnsupportedPackageTypeException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensiblePackageProcessor
implements PackageProcessor {
    private PackageProcessorExtensionPoint processors;
    private TypeDescriber packageTypeDescriber;
    private Monitor monitor;

    public ExtensiblePackageProcessor(PackageProcessorExtensionPoint processors, TypeDescriber packageTypeDescriber, Monitor monitor) {
        this.processors = processors;
        this.packageTypeDescriber = packageTypeDescriber;
        this.monitor = monitor;
    }

    protected void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    @Override
    public List<URI> getArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
        String packageType = this.packageTypeDescriber.getType(packageSourceURL, null);
        if (packageType == null) {
            this.error("UnsupportedPackageTypeException", this.packageTypeDescriber, packageSourceURL.toString());
            throw new UnsupportedPackageTypeException("Unsupported contribution package type: " + packageSourceURL.toString());
        }
        PackageProcessor packageProcessor = this.processors.getPackageProcessor(packageType);
        if (packageProcessor == null) {
            this.error("UnsupportedPackageTypeException", this.packageTypeDescriber, packageType);
            throw new UnsupportedPackageTypeException("Unsupported contribution package type: " + packageType);
        }
        return packageProcessor.getArtifacts(packageSourceURL, inputStream);
    }

    @Override
    public URL getArtifactURL(URL packageSourceURL, URI artifact) throws MalformedURLException {
        String contentType = this.packageTypeDescriber.getType(packageSourceURL, null);
        PackageProcessor packageProcessor = this.processors.getPackageProcessor(contentType);
        return packageProcessor.getArtifactURL(packageSourceURL, artifact);
    }

    @Override
    public String getPackageType() {
        return null;
    }
}

