/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.stax;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.common.xml.stax.impl.StAX2SAXAdapter;
import org.apache.tuscany.sca.common.xml.stax.impl.XMLStreamSerializer;
import org.apache.tuscany.sca.common.xml.stax.reader.DOMXMLStreamReader;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StAXHelper {
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final DOMHelper domHelper;

    public StAXHelper(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        factories.getFactory(XMLInputFactory.class);
        this.inputFactory = (XMLInputFactory)factories.getFactory(XMLInputFactory.class);
        this.outputFactory = (XMLOutputFactory)factories.getFactory(XMLOutputFactory.class);
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.domHelper = (DOMHelper)utilities.getUtility(DOMHelper.class);
    }

    public static StAXHelper getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        return (StAXHelper)utilities.getUtility(StAXHelper.class);
    }

    public StAXHelper(XMLInputFactory inputFactory, XMLOutputFactory outputFactory, DOMHelper domHelper) {
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        if (outputFactory != null) {
            this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        this.domHelper = domHelper;
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return this.inputFactory.createXMLStreamReader(inputStream);
    }

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.inputFactory.createXMLStreamReader(reader);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.inputFactory.createXMLStreamReader(source);
    }

    public XMLStreamReader createXMLStreamReader(Node node) throws XMLStreamException {
        return new DOMXMLStreamReader(node);
    }

    public XMLStreamReader createXMLStreamReader(String string) throws XMLStreamException {
        StringReader reader = new StringReader(string);
        return this.createXMLStreamReader(reader);
    }

    private static InputStream openStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            connection.setUseCaches(false);
        }
        InputStream is = connection.getInputStream();
        return is;
    }

    public XMLStreamReader createXMLStreamReader(URL url) throws XMLStreamException {
        try {
            StreamSource scdlSource = new StreamSource(StAXHelper.openStream(url), url.toString());
            return this.inputFactory.createXMLStreamReader(scdlSource);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public String saveAsString(XMLStreamReader reader) throws XMLStreamException {
        StringWriter writer = new StringWriter();
        this.save(reader, writer);
        return writer.toString();
    }

    public void save(XMLStreamReader reader, OutputStream outputStream) throws XMLStreamException {
        XMLStreamWriter streamWriter = this.createXMLStreamWriter(outputStream);
        this.save(reader, streamWriter);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.outputFactory.createXMLStreamWriter(outputStream);
    }

    public void save(XMLStreamReader reader, Writer writer) throws XMLStreamException {
        XMLStreamWriter streamWriter = this.createXMLStreamWriter(writer);
        this.save(reader, streamWriter);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.outputFactory.createXMLStreamWriter(writer);
    }

    public Node saveAsNode(XMLStreamReader reader) throws XMLStreamException {
        Document root = this.domHelper.newDocument();
        DOMHelper.NodeContentHandler handler = this.domHelper.createContentHandler(root);
        try {
            this.saveAsSAX(reader, handler);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
        return root;
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.outputFactory.createXMLStreamWriter(result);
    }

    public void save(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamSerializer serializer = new XMLStreamSerializer(this.isReparingNamespaces());
        serializer.serialize(reader, writer);
        writer.flush();
    }

    public void saveAsSAX(XMLStreamReader reader, ContentHandler contentHandler) throws XMLStreamException, SAXException {
        new StAX2SAXAdapter(false).parse(reader, contentHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAttribute(URL url, QName element, String attribute) throws IOException, XMLStreamException {
        if (attribute == null) {
            attribute = "targetNamespace";
        }
        XMLStreamReader reader = this.createXMLStreamReader(url);
        try {
            String string = this.readAttributeFromRoot(reader, element, attribute);
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readAttributes(URL url, QName element, String attribute) throws IOException, XMLStreamException {
        if (attribute == null) {
            attribute = "targetNamespace";
        }
        XMLStreamReader reader = this.createXMLStreamReader(url);
        try {
            Attribute attr = new Attribute(element, attribute);
            List<String> list = this.readAttributes(reader, attr)[0].getValues();
            return list;
        }
        finally {
            reader.close();
        }
    }

    public static Boolean getAttributeAsBoolean(XMLStreamReader reader, String name) {
        String value = reader.getAttributeValue(null, name);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static QName getAttributeAsQName(XMLStreamReader reader, String name) {
        String qname = reader.getAttributeValue(null, name);
        return StAXHelper.getValueAsQName(reader, qname);
    }

    public static List<QName> getAttributeAsQNames(XMLStreamReader reader, String name) {
        String value = reader.getAttributeValue(null, name);
        if (value != null) {
            ArrayList<QName> qnames = new ArrayList<QName>();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                qnames.add(StAXHelper.getValueAsQName(reader, tokens.nextToken()));
            }
            return qnames;
        }
        return Collections.emptyList();
    }

    public static QName getValueAsQName(XMLStreamReader reader, String value) {
        if (value != null) {
            int index = value.indexOf(58);
            String prefix = index == -1 ? "" : value.substring(0, index);
            String localName = index == -1 ? value : value.substring(index + 1);
            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
            if (ns == null) {
                ns = "";
            }
            return new QName(ns, localName, prefix);
        }
        return null;
    }

    public static String getAttributeAsString(XMLStreamReader reader, String name) {
        return reader.getAttributeValue(null, name);
    }

    public static String getAttributeAsURIString(XMLStreamReader reader, String name) {
        String uri = reader.getAttributeValue(null, name);
        if (uri != null) {
            uri = uri.replace('\t', ' ');
            uri = uri.replace('\n', ' ');
            uri = uri.replace('\r', ' ');
            uri = uri.trim();
            StringBuilder sb = new StringBuilder(uri.length());
            boolean spaceFound = false;
            for (int i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == ' ') {
                    if (spaceFound) continue;
                    sb.append(c);
                    spaceFound = true;
                    continue;
                }
                sb.append(c);
                spaceFound = false;
            }
            uri = sb.toString();
        }
        return uri;
    }

    public static QName getXSIType(XMLStreamReader reader) {
        String qname = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        return StAXHelper.getValueAsQName(reader, qname);
    }

    public static boolean isAttributePresent(XMLStreamReader reader, String name) {
        return reader.getAttributeValue(null, name) != null;
    }

    public static void skipToEndElement(XMLStreamReader reader) throws XMLStreamException {
        int depth = 0;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                ++depth;
                continue;
            }
            if (event != 2) continue;
            if (depth == 0) {
                return;
            }
            --depth;
        }
    }

    private Attribute[] readAttributes(XMLStreamReader reader, AttributeFilter filter) throws XMLStreamException {
        XMLStreamReader newReader = this.inputFactory.createFilteredReader(reader, filter);
        while (filter.proceed() && newReader.hasNext()) {
            newReader.next();
        }
        return filter.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute[] readAttributes(URL url, Attribute ... attributes) throws XMLStreamException {
        XMLStreamReader reader = this.createXMLStreamReader(url);
        try {
            Attribute[] attributeArray = this.readAttributes(reader, attributes);
            return attributeArray;
        }
        finally {
            reader.close();
        }
    }

    public Attribute[] readAttributes(XMLStreamReader reader, Attribute ... attributes) throws XMLStreamException {
        return this.readAttributes(reader, new AttributeFilter(false, attributes));
    }

    private String readAttributeFromRoot(XMLStreamReader reader, Attribute filter) throws XMLStreamException {
        Attribute[] attrs = this.readAttributes(reader, new AttributeFilter(true, filter));
        List<String> values = attrs[0].getValues();
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public String readAttributeFromRoot(XMLStreamReader reader, QName element, String attributeName) throws XMLStreamException {
        Attribute filter = new Attribute(element, attributeName);
        return this.readAttributeFromRoot(reader, filter);
    }

    public XMLInputFactory getInputFactory() {
        return this.inputFactory;
    }

    private boolean isReparingNamespaces() {
        if (this.outputFactory == null) {
            return Boolean.TRUE;
        }
        return this.outputFactory.getProperty("javax.xml.stream.isRepairingNamespaces") == Boolean.TRUE;
    }

    public XMLOutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    public String writeAttribute(XMLStreamWriter writer, QName name, String value) throws XMLStreamException {
        return this.writeAttribute(writer, name.getPrefix(), name.getLocalPart(), name.getNamespaceURI(), value);
    }

    public String writeAttribute(XMLStreamWriter writer, String prefix, String localName, String namespaceURI, String value) throws XMLStreamException {
        if (value == null) {
            return null;
        }
        XMLStreamSerializer serializer = new XMLStreamSerializer(this.isReparingNamespaces());
        return serializer.writeAttribute(writer, prefix, localName, namespaceURI, value);
    }

    public void writeStartElement(XMLStreamWriter writer, QName name) throws XMLStreamException {
        this.writeStartElement(writer, name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
    }

    public void writeStartElement(XMLStreamWriter writer, String prefix, String localName, String namespaceURI) throws XMLStreamException {
        XMLStreamSerializer serializer = new XMLStreamSerializer(this.isReparingNamespaces());
        serializer.writeStartElement(writer, prefix, localName, namespaceURI);
    }

    public String writeNamespace(XMLStreamWriter writer, String prefix, String namespaceURI) throws XMLStreamException {
        XMLStreamSerializer serializer = new XMLStreamSerializer(this.isReparingNamespaces());
        return serializer.writeNamespace(writer, prefix, namespaceURI);
    }

    private static class AttributeFilter
    implements StreamFilter {
        private boolean proceed = true;
        private Attribute[] attributes;
        private boolean rootOnly;

        public AttributeFilter(boolean rootOnly, Attribute ... attributes) {
            this.rootOnly = rootOnly;
            this.attributes = attributes;
        }

        @Override
        public boolean accept(XMLStreamReader reader) {
            if (this.attributes == null || this.attributes.length == 0) {
                this.proceed = false;
                return true;
            }
            if (reader.getEventType() == 1) {
                QName name = reader.getName();
                for (Attribute attr : this.attributes) {
                    if (!attr.element.equals(name)) continue;
                    attr.values.add(reader.getAttributeValue(null, attr.name));
                }
                if (this.rootOnly) {
                    this.proceed = false;
                }
            }
            return true;
        }

        public boolean proceed() {
            return this.proceed;
        }
    }

    public static class Attribute {
        private QName element;
        private String name;
        private List<String> values = new ArrayList<String>();

        public Attribute(QName element, String name) {
            this.element = element;
            this.name = name;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

