/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.dom;

import java.util.IdentityHashMap;
import java.util.Map;

public abstract class ParserPool<V> {
    private int maxSize;
    private Map<V, Boolean> objects;

    public ParserPool() {
        this(32, 0);
    }

    public ParserPool(int maxSize, int initialSize) {
        this.maxSize = maxSize;
        this.objects = new IdentityHashMap<V, Boolean>(maxSize);
        for (int i = 0; i < Math.min(initialSize, maxSize); ++i) {
            this.objects.put((Boolean)this.newInstance(), Boolean.FALSE);
        }
    }

    public synchronized V borrowFromPool() {
        while (true) {
            for (Map.Entry<V, Boolean> e : this.objects.entrySet()) {
                if (!Boolean.FALSE.equals(e.getValue())) continue;
                V key = e.getKey();
                this.objects.put((Boolean)key, Boolean.TRUE);
                return key;
            }
            if (this.objects.size() < this.maxSize) {
                V obj = this.newInstance();
                this.objects.put((Boolean)obj, Boolean.TRUE);
                return obj;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e1) {
                throw new IllegalStateException(e1);
            }
        }
    }

    public synchronized void returnToPool(V obj) {
        this.resetInstance(obj);
        this.objects.put((Boolean)obj, Boolean.FALSE);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.objects.clear();
    }

    public synchronized int inUse() {
        int size = 0;
        for (Map.Entry<V, Boolean> e : this.objects.entrySet()) {
            if (!Boolean.TRUE.equals(e.getValue())) continue;
            ++size;
        }
        return size;
    }

    protected abstract V newInstance();

    protected abstract void resetInstance(V var1);

    public Map<V, Boolean> getObjects() {
        return this.objects;
    }
}

