/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.java.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionMap<K, V>
extends ConcurrentHashMap<K, Collection<V>> {
    private static final long serialVersionUID = -8926174610229029369L;

    public boolean putValue(K key, V value) {
        Collection<V> collection = (Collection<V>)this.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.put(key, collection);
        }
        return collection.add(value);
    }

    public boolean putValues(K key, Collection<? extends V> value) {
        Collection<V> collection = (Collection<V>)this.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.put(key, collection);
        }
        return collection.addAll(value);
    }

    public boolean removeValue(K key, V value) {
        return this.removeValue(key, value, false);
    }

    public boolean removeValue(K key, V value, boolean removeEmptyEntry) {
        Collection collection = (Collection)this.get(key);
        if (collection == null) {
            return false;
        }
        boolean result = collection.remove(value);
        if (removeEmptyEntry && collection.isEmpty()) {
            this.remove(key);
        }
        return result;
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }
}

