/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuscanyListenerManager
extends ListenerManager {
    private static final Log log = LogFactory.getLog(TuscanyListenerManager.class);
    private ListenerManagerShutdownThread shutdownThread = null;

    public synchronized void start() {
        ConfigurationContext configctx = this.getConfigctx();
        HashMap startedTransports = null;
        try {
            Field field = ListenerManager.class.getDeclaredField("startedTransports");
            field.setAccessible(true);
            startedTransports = (HashMap)field.get((Object)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Iterator transportNames = configctx.getAxisConfiguration().getTransportsIn().values().iterator();
        while (transportNames.hasNext()) {
            try {
                TransportInDescription transportIn = (TransportInDescription)transportNames.next();
                TransportListener listener = transportIn.getReceiver();
                if (listener == null || startedTransports.get(transportIn.getName()) != null) continue;
                listener.init(configctx, transportIn);
                listener.start();
                if (startedTransports.get(transportIn.getName()) != null) continue;
                startedTransports.put(transportIn.getName(), listener);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.shutdownThread = new ListenerManagerShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public synchronized void stop() throws AxisFault {
        super.stop();
        try {
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                this.shutdownThread = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.shutdownThread = null;
        }
    }

    static class ListenerManagerShutdownThread
    extends Thread {
        ListenerManager listenerManager;

        public ListenerManagerShutdownThread(ListenerManager listenerManager) {
            this.listenerManager = listenerManager;
        }

        public void run() {
            try {
                this.listenerManager.stop();
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
            }
        }
    }
}

