/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.i18n.Messages;

public class TuscanyAxisConfigurator
extends URLBasedAxisConfigurator
implements AxisConfigurator {
    private URL axis2_xml = TuscanyAxisConfigurator.getResource("/org/apache/tuscany/sca/binding/ws/axis2/engine/config/axis2.xml");
    private URL axis2_repository = null;
    private URL rampart_mar_url = TuscanyAxisConfigurator.getResource("/org/apache/tuscany/sca/binding/ws/axis2/engine/config/modules/rampart-1.4.mar");
    private boolean isRampartRequired;

    public TuscanyAxisConfigurator(boolean isRampartRequired) throws AxisFault {
        super(TuscanyAxisConfigurator.getResource("/org/apache/tuscany/sca/binding/ws/axis2/engine/config/axis2.xml"), null);
        this.isRampartRequired = isRampartRequired;
    }

    private static URL getResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return TuscanyAxisConfigurator.class.getResource(name);
            }
        });
    }

    public ConfigurationContext getConfigurationContext() throws AxisFault {
        if (this.configContext == null) {
            this.configContext = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)this);
        }
        return this.configContext;
    }

    private InputStream getResourceAsStream(final String resource) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl.getResourceAsStream(resource);
            }
        });
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        block11: {
            try {
                InputStream axis2xmlStream = this.axis2_xml == null ? this.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml") : this.axis2_xml.openStream();
                this.axisConfig = this.populateAxisConfiguration(axis2xmlStream);
                if (this.isRampartRequired) {
                    this.axisConfig.addGlobalModuleRef("rampart");
                }
                if (this.axis2_repository == null) {
                    Parameter axis2repoPara = this.axisConfig.getParameter("repository");
                    if (axis2repoPara != null) {
                        String repoValue = (String)axis2repoPara.getValue();
                        if (repoValue != null && !"".equals(repoValue.trim())) {
                            if (repoValue.startsWith("file:/")) {
                                this.loadRepository(repoValue);
                            } else {
                                this.loadRepositoryFromURL(new URL(repoValue));
                            }
                        }
                        break block11;
                    }
                    try {
                        this.loadFromClassPath();
                    }
                    catch (Exception exception) {
                        if (this.isRampartRequired) {
                            this.loadRampartModule();
                        }
                        break block11;
                    }
                }
                this.loadRepositoryFromURL(this.axis2_repository);
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage());
            }
        }
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        return this.axisConfig;
    }

    public void loadRampartModule() throws DeploymentException {
        try {
            ClassLoader deploymentClassLoader = Utils.createClassLoader((URL[])new URL[]{this.rampart_mar_url}, (ClassLoader)this.axisConfig.getModuleClassLoader(), (boolean)true, (File)((File)this.axisConfig.getParameterValue("artifactsDIR")));
            final AxisModule module = new AxisModule();
            module.setModuleClassLoader(deploymentClassLoader);
            module.setParent(this.axisConfig);
            if (module.getName() == null) {
                module.setName("rampart");
                module.setVersion("1.4");
            }
            this.populateModule(module, this.rampart_mar_url);
            module.setFileName(this.rampart_mar_url);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        TuscanyAxisConfigurator.addNewModule((AxisModule)module, (AxisConfiguration)((DeploymentEngine)TuscanyAxisConfigurator.this).axisConfig);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (AxisFault)((Object)e.getException());
            }
            TuscanyAxisConfigurator.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public static String getModuleName(String moduleName) {
        if (moduleName.endsWith("-SNAPSHOT")) {
            return moduleName.substring(0, moduleName.indexOf("-SNAPSHOT"));
        }
        int delimiter = 45;
        int version_index = moduleName.lastIndexOf(delimiter);
        if (version_index > 0) {
            String versionString = TuscanyAxisConfigurator.getModuleVersion(moduleName);
            if (versionString == null) {
                return moduleName;
            }
            return moduleName.substring(0, version_index);
        }
        return moduleName;
    }

    public static String getModuleVersion(String moduleName) {
        if (moduleName.endsWith("-SNAPSHOT")) {
            return "SNAPSHOT";
        }
        int version_seperator = 45;
        int version_index = moduleName.lastIndexOf(version_seperator);
        if (version_index > 0) {
            String versionString = moduleName.substring(version_index + 1, moduleName.length());
            try {
                Float.parseFloat(versionString);
                return versionString;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static String getModuleName(String moduleName, String moduleVersion) {
        if (moduleVersion != null && moduleVersion.length() != 0) {
            moduleName = String.valueOf(moduleName) + "-" + moduleVersion;
        }
        return moduleName;
    }

    public static boolean isLatest(String moduleVersion, String currentDefaultVersion) {
        float m_c_vresion;
        if ("SNAPSHOT".equals(moduleVersion)) {
            return true;
        }
        float m_version = Float.parseFloat(moduleVersion);
        return m_version > (m_c_vresion = Float.parseFloat(currentDefaultVersion));
    }

    public static void calculateDefaultModuleVersion(HashMap modules, AxisConfiguration axisConfig) {
        Iterator allModules = modules.values().iterator();
        HashMap<String, String> defaultModules = new HashMap<String, String>();
        while (allModules.hasNext()) {
            String moduleVersionString;
            String moduleNameString;
            AxisModule axisModule = (AxisModule)allModules.next();
            String moduleName = axisModule.getName();
            if ("SNAPSHOT".equals(axisModule.getVersion())) {
                moduleNameString = axisModule.getName();
                moduleVersionString = axisModule.getVersion();
            } else if (axisModule.getVersion() == null) {
                moduleNameString = TuscanyAxisConfigurator.getModuleName(moduleName);
                moduleVersionString = TuscanyAxisConfigurator.getModuleVersion(moduleName);
                if (moduleVersionString != null) {
                    try {
                        Float.valueOf(moduleVersionString);
                        axisModule.setVersion(moduleVersionString);
                        axisModule.setName(moduleName);
                    }
                    catch (NumberFormatException numberFormatException) {
                        moduleVersionString = null;
                    }
                }
            } else {
                moduleNameString = axisModule.getName();
                moduleVersionString = axisModule.getVersion();
            }
            String currentDefaultVerison = (String)defaultModules.get(moduleNameString);
            if (currentDefaultVerison != null) {
                if ("SNAPSHOT".equals(currentDefaultVerison) || moduleVersionString == null || !TuscanyAxisConfigurator.isLatest(moduleVersionString, currentDefaultVerison)) continue;
                defaultModules.put(moduleNameString, moduleVersionString);
                continue;
            }
            defaultModules.put(moduleNameString, moduleVersionString);
        }
        for (String moduleName : defaultModules.keySet()) {
            axisConfig.addDefaultModuleVersion(moduleName, (String)defaultModules.get(moduleName));
        }
    }

    private void populateModule(AxisModule module, URL moduleUrl) throws DeploymentException {
        try {
            ClassLoader classLoader = module.getModuleClassLoader();
            InputStream moduleStream = classLoader.getResourceAsStream("META-INF/module.xml");
            if (moduleStream == null) {
                moduleStream = classLoader.getResourceAsStream("meta-inf/module.xml");
            }
            if (moduleStream == null) {
                throw new DeploymentException(Messages.getMessage((String)"modulexmlnotfound", (String)moduleUrl.toString()));
            }
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, module, this.axisConfig);
            moduleBuilder.populateModule();
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

