/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceClient;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ReferenceBindingProvider
implements ReferenceBindingProvider {
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private WebServiceBinding wsBinding;
    private Axis2ServiceClient axisClient;

    public Axis2ReferenceBindingProvider(EndpointReference endpointReference, FactoryExtensionPoint modelFactories, DataBindingExtensionPoint dataBindings) {
        MessageFactory messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        this.wsBinding = (WebServiceBinding)endpointReference.getBinding();
        this.component = (RuntimeComponent)endpointReference.getComponent();
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        if (this.wsBinding.getWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + this.component.getName() + "/" + this.reference.getName());
        }
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        if (contract.getInterface() != null) {
            contract.getInterface().resetDataBinding(OMElement.class.getName());
        }
        this.axisClient = new Axis2ServiceClient(this.component, (AbstractContract)this.reference, this.wsBinding, messageFactory);
    }

    public void start() {
        this.axisClient.start();
    }

    public void stop() {
        this.axisClient.stop();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public Invoker createInvoker(Operation operation) {
        return this.axisClient.createInvoker(operation);
    }
}

